// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/rx_fifo_full_cfg.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("Rx FIFO Full Config.");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_RX_FIFO_FULL_CFG_OVER:

			ptr	= "Overrun the FIFO";
			break;

		case SIO4_ASYNC_RX_FIFO_FULL_CFG_DISABLE:

			ptr	= "Disable the Receiver";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_rx_fifo_full_cfg(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->rx.fifo.full_cfg"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_rx_fifo_full_cfg(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_RX_FIFO_FULL_CFG_OVER;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_rx_fifo_full_cfg(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:					errs	= 1;	break;
					case -1:
					case SIO4_ASYNC_RX_FIFO_FULL_CFG_OVER:
					case SIO4_ASYNC_RX_FIFO_FULL_CFG_DISABLE:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


