// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/osc_prog.c $
// $Rev: 32775 $
// $Date: 2015-09-07 15:34:15 -0500 (Mon, 07 Sep 2015) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Oscillator Program");

	if (set < 0)
	{
		printf("This service is not supported by this board.\n");
	}
	else if (set == 0)
	{
		//errs++;
		printf("Not recorded for later retrieval (0).\n");
	}
	else if (set == 1)
	{
		printf("This service is supported by this board (1).\n");
	}
	else
	{
		gsc_label_long_comma(set);
		printf(" Hz\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_async_t_osc_prog(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->osc.prog"
	int			errs	= 0;
	const char*	sts		= NULL;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= 0;
				errs	= sio4_query(fd, SIO4_QUERY_OSC_PROGRAM, arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= 20000000L;
				break;

		case SIO4_ASYNC_ACTION_SET:

				errs	= sio4_osc_program(fd, -1, 0, arg[0], NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				if (arg[0] < -1)
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


