// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/lib.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



// variables ******************************************************************

static	int			_initialized;
static device_t*	_list[30];
static	os_sem_t	_sem;



//*****************************************************************************
device_t* lib_dev_alloc_inc(void)
{
	device_t*	dev		= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_async_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == NULL)
			{
				dev	= malloc(sizeof(device_t));

				if (dev)
				{
					memset(dev, 0, sizeof(device_t));
					dev->users++;
					_list[i]	= dev;
					break;
				}
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(dev);
}



//*****************************************************************************
int lib_dev_dec(device_t* dev)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_async_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		if (dev->users > 0)
			dev->users--;

		os_sem_unlock(&_sem);
		break;
	}

	return(ret);
}



//*****************************************************************************
int lib_dev_dec_release(device_t* dev)
{
	int	i;
	int	ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_async_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		if (dev->users > 1)
		{
			os_sem_unlock(&_sem);
			ret	= -EBUSY;
			break;
		}

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == dev)
			{
				_list[i]	= NULL;
				break;
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(ret);
}



//*****************************************************************************
device_t* lib_fd_find_inc(int fd)
{
	device_t*	dev	= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		ret	= sio4_async_lib_init();

		if (ret)
			break;

		ret	= os_sem_lock(&_sem);

		if (ret)
			break;

		for (i = 0; i < (int) ARRAY_ELEMENTS(_list); i++)
		{
			if (_list[i] == NULL)
				continue;

			if (_list[i]->fd == fd)
			{
				dev	= _list[i];
				break;
			}
		}

		os_sem_unlock(&_sem);
		break;
	}

	return(dev);
}



//*****************************************************************************
int sio4_async_lib_init(void)
{
	int	ret	= 0;

	for (;;)	// A convenience loop.
	{
		if (_initialized)
			break;

		_initialized	= 1;
		ret				= os_sem_create(&_sem);

		if (ret)
			_initialized	= 0;

		break;
	}

	return(ret);
}


