// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/ioctl.c $
// $Rev: 33919 $
// $Date: 2015-10-07 14:43:18 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_async_ioctl
*
*	Purpose:
*
*		Issue an IOCTL request for an SIO4 channel opened for Asynchronous use.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		cmd		The IOCTL service to issue.
*
*		arg		The argument associated with the IOCTL service being requested.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_async_ioctl(int fd, int cmd, void* arg)
{
	int	ret;

	// Make sure the library is initialized.
	ret	= sio4_async_lib_init();

	if (ret == 0)
	{
		// Perform the requested operation.
		ret	= sio4_ioctl(fd, cmd, arg);
	}

	return(ret);
}



