// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/cable_rts.c $
// $Rev: 31500 $
// $Date: 2014-12-09 18:30:36 -0600 (Tue, 09 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("Cable RTS");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ASYNC_CABLE_RTS_OUT_CTS:

			ptr	= "Output USC CTS";
			break;

		case SIO4_ASYNC_CABLE_RTS_OUT_RTS:

			ptr	= "Output RTS";
			break;

		case SIO4_ASYNC_CABLE_RTS_OUT_0:

			ptr	= "Output Low";
			break;

		case SIO4_ASYNC_CABLE_RTS_OUT_1:

			ptr	= "Output High";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_async_t_cable_rts(
	int					fd,
	s32*				arg,
	sio4_async_action_t	action,
	const char**		err)
{
	#define		ERROR	  "async->cable.rts"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ASYNC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_z16_cbl_rts_cfg(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ASYNC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ASYNC_CABLE_RTS_OUT_RTS;
				break;

		case SIO4_ASYNC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_z16_cbl_rts_cfg(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ASYNC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ASYNC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:			errs	= 1;	break;
					case -1:
					case SIO4_ASYNC_CABLE_RTS_OUT_CTS:
					case SIO4_ASYNC_CABLE_RTS_OUT_RTS:
					case SIO4_ASYNC_CABLE_RTS_OUT_0:
					case SIO4_ASYNC_CABLE_RTS_OUT_1:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


