// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_zilog.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



// macros *********************************************************************

#define	BRG0_CTR0							SIO4_USC_CMCR_BRGSRC_CTR0
#define	BRG0_TXC							SIO4_USC_CMCR_BRGSRC_TXC

#define	BRG1_CTR1							SIO4_USC_CMCR_BRGSRC_CTR1
#define	BRG1_TXC							SIO4_USC_CMCR_BRGSRC_TXC

#define	CTR0_4								SIO4_USC_HCR_CTR0DIV_4
#define	CTR0_8								SIO4_USC_HCR_CTR0DIV_8
#define	CTR0_16								SIO4_USC_HCR_CTR0DIV_16
#define	CTR0_32								SIO4_USC_HCR_CTR0DIV_32

#define	CTR0_OFF							SIO4_USC_CMCR_CTRSRC_DISABLE
#define	CTR0_TXC							SIO4_USC_CMCR_CTRSRC_TXC

#define	CTR1_OFF							SIO4_USC_CMCR_CTRSRC_DISABLE
#define	CTR1_TXC							SIO4_USC_CMCR_CTRSRC_TXC

#define	DPLL_4								SIO4_USC_HCR_DPLLDIV_4	// Use for CTR1 only.
#define	DPLL_8								SIO4_USC_HCR_DPLLDIV_8
#define	DPLL_16								SIO4_USC_HCR_DPLLDIV_16
#define	DPLL_32								SIO4_USC_HCR_DPLLDIV_32

#define	DPLL_TXC							SIO4_USC_CMCR_DPLLSRC_TXC
#define	DPLL_BRG1							SIO4_USC_CMCR_DPLLSRC_BRG1

#define	TXCLK_BRG0							SIO4_USC_CMCR_CLKSRC_BRG0
#define	TXCLK_CTR0							SIO4_USC_CMCR_CLKSRC_CTR0
#define	TXCLK_TXC							SIO4_USC_CMCR_CLKSRC_TXC

// Useless code for the validation script.
//	if (verbose
//	if (verbose



/******************************************************************************
*
*	Function:	zilog_dpll_baud_compute
*
*	Purpose:
*
*		Compute the relavent settings needed to achieve the desired receive
*		baudrate using the DPLL. The desired baudrate may not be matched
*		exactly. It is up to the caller to decide if the resulting baudrate is
*		acceptable.
*
*	Arguments:
*
*		config	The input parameter are provided here and the computed
*				parameters are stored here.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void zilog_dpll_baud_compute(zilog_rx_baud_config_t* config)
{
	static const struct
	{
		unsigned int	ctr1_src	: 2;	// CMCR.CTR1Src
		unsigned int	brg1_enable	: 1;	// HCR.BRG1E
		unsigned int	brg1_src	: 2;	// CMCR.BRG1Src
		unsigned int	dpll_src	: 2;	// CMCR.DPLLSrc
		unsigned int	dpll_div	: 2;	// HCR.DPLLDiv
		unsigned int	divisor;			// 8, 16, 32, and ^2
	} list[]	=
	{
		// CTR1		BRG1				DPLL		Divisor
		// src		enable	src			src			div
		{ CTR1_OFF, 0,		BRG1_CTR1,	DPLL_TXC,	DPLL_32,	32		},
		{ CTR1_OFF, 0,		BRG1_CTR1,	DPLL_TXC,	DPLL_16,	16		},
		{ CTR1_OFF, 0,		BRG1_CTR1,	DPLL_TXC,	DPLL_8,		 8		},

		{ CTR1_OFF, 1,		BRG1_TXC,	DPLL_BRG1,	DPLL_32,	32		},
		{ CTR1_OFF, 1,		BRG1_TXC,	DPLL_BRG1,	DPLL_16,	16		},
		{ CTR1_OFF, 1,		BRG1_TXC,	DPLL_BRG1,	DPLL_8,		 8		},

		{ CTR1_TXC, 1,		BRG1_CTR1,	DPLL_BRG1,	DPLL_32,	32 * 32	},
		{ CTR1_TXC, 1,		BRG1_CTR1,	DPLL_BRG1,	DPLL_16,	16 * 16	},
		{ CTR1_TXC, 1,		BRG1_CTR1,	DPLL_BRG1,	DPLL_8,		 8 *  8	},

		{ 0,		0,		0,			0,			0,			0		}
	};

	long	d1			= -1;
	long	d2			= 0;
	long	divisor;
	int		i;
	long	r1;
	long	r2;
	long	rxclk;
	long	tc1r_value	= 0;

	for (i = 0; list[i].divisor; i++)
	{
		rxclk	= config->rxc_rate / list[i].divisor;

		if (list[i].brg1_enable)
		{
			divisor	= rxclk / config->baudrate;

			if (divisor == 0)
				divisor++;
			else if (divisor >= 65536L)
				divisor	= 65535L;

			r1	= rxclk / divisor;
			r2	= rxclk / (divisor + 1);
			d1	= labs(config->baudrate - r1);
			d2	= labs(config->baudrate - r2);

			if (d1 < d2)
			{
				tc1r_value	= divisor;
				rxclk		= r1;
			}
			else
			{
				tc1r_value	= divisor + 1;
				rxclk		= r2;
			}
		}

		if (i)
		{
			d1	= labs(config->baudrate - rxclk);
			d2	= config->baudrate - config->baudrate_comp;
			d2	= labs(d2);
		}

		if ((i == 0) || (d1 < d2))
		{
			config->brg1_enable	= list[i].brg1_enable;
			config->brg1_src	= list[i].brg1_src;
			config->ctr1_src	= list[i].ctr1_src;
			config->ctr1_div_sel	= SIO4_USC_HCR_CTR1DSEL_DPLLDIV;
			config->dpll_div	= list[i].dpll_div;
			config->dpll_src	= list[i].dpll_src;
			config->rxclk_src	= SIO4_USC_CMCR_CLKSRC_DPLL;
			config->tc1r_value	= tc1r_value - 1;
			config->baudrate_comp	= rxclk;
		}
	}

	switch (config->encoding)
	{
		default:
		case SIO4_USC_ENCODING_NRZ:
		case SIO4_USC_ENCODING_NRZB:
		case SIO4_USC_ENCODING_NRZI_MARK:
		case SIO4_USC_ENCODING_NRZI_SPACE:

			config->dpll_mode	= SIO4_USC_HCR_DPLLMODE_NRZ;
			break;

		case SIO4_USC_ENCODING_BIPH_MARK:
		case SIO4_USC_ENCODING_BIPH_SPACE:

			config->dpll_mode	= SIO4_USC_HCR_DPLLMODE_BIPH_MS;
			break;

		case SIO4_USC_ENCODING_BIPH_LEVEL:
		case SIO4_USC_ENCODING_D_BIPH_LEVEL:

			config->dpll_mode	= SIO4_USC_HCR_DPLLMODE_BIPH_L;
			break;
	}
}



/******************************************************************************
*
*	Function:	zilog_rx_baud_compute
*
*	Purpose:
*
*		Compute the relavent settings needed to achieve the desired receive
*		baudrate. The desired baudrate may not be matched exactly. It is up to
*		the caller to decide if the resulting baudrate is acceptable.
*
*	Arguments:
*
*		config	The input parameter are provided here and the computed
*				parameters are stored here.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void zilog_rx_baud_compute(zilog_rx_baud_config_t* config)
{
	#define	RXCLK_TXC	SIO4_USC_CMCR_CLKSRC_TXC
	#define	RXCLK_BRG1	SIO4_USC_CMCR_CLKSRC_BRG1
	#define	RXCLK_CTR1	SIO4_USC_CMCR_CLKSRC_CTR1

	static const struct
	{
		unsigned int	ctr1_src	: 2;	// CMCR.CTR1Src
		unsigned int	ctr1_divisor	: 8;// 1, 4, 8, 16, 32
		unsigned int	dpll_div	: 2;	// HCR.DPLLDiv
		unsigned int	brg1_enable	: 1;	// HCR.BRG1E
		unsigned int	brg1_src	: 2;	// CMCR.BRG1Src
		unsigned int	rxclk_src	: 3;	// CMCR.RxCLKSrc
	} list[]	=
	{
		// CTR1		DPLL				BRG1				RXCLK
		// src		divisor div			enable	src			src
		{ CTR1_OFF,	 1,		DPLL_4,		0,		BRG1_TXC,	RXCLK_TXC	},
		{ CTR1_TXC,	 4,		DPLL_4,		0,		BRG1_TXC,	RXCLK_CTR1	},
		{ CTR1_TXC,	 8,		DPLL_8,		0,		BRG1_TXC,	RXCLK_CTR1	},
		{ CTR1_TXC,	16,		DPLL_16,	0,		BRG1_TXC,	RXCLK_CTR1	},
		{ CTR1_TXC,	32,		DPLL_32,	0,		BRG1_TXC,	RXCLK_CTR1	},

		{ CTR1_OFF,	 1,		DPLL_4,		1,		BRG1_TXC,	RXCLK_BRG1	},
		{ CTR1_TXC,	 4,		DPLL_4,		1,		BRG1_CTR1,	RXCLK_BRG1	},
		{ CTR1_TXC,	 8,		DPLL_8,		1,		BRG1_CTR1,	RXCLK_BRG1	},
		{ CTR1_TXC,	16,		DPLL_16,	1,		BRG1_CTR1,	RXCLK_BRG1	},
		{ CTR1_TXC,	32,		DPLL_32,	1,		BRG1_CTR1,	RXCLK_BRG1	},

		{ 0,		0,		0,			0,		0,			0			}
	};

	long	tc1r_value	= 0;
	long	d1			= -1;
	long	d2			= 0;
	long	divisor;
	int		i;
	long	r1;
	long	r2;
	long	rxclk;

	config->ctr1_div_sel	= SIO4_USC_HCR_CTR1DSEL_DPLLDIV;

	for (i = 0; list[i].ctr1_divisor; i++)
	{
		rxclk	= config->rxc_rate / list[i].ctr1_divisor;

		if (list[i].brg1_enable)
		{
			divisor	= rxclk / config->baudrate;

			if (divisor == 0)
				divisor++;
			else if (divisor >= 65536L)
				divisor	= 65535L;

			r1	= rxclk / divisor;
			r2	= rxclk / (divisor + 1);
			d1	= labs(config->baudrate - r1);
			d2	= labs(config->baudrate - r2);

			if (d1 < d2)
			{
				tc1r_value	= divisor - 1;
				rxclk		= r1;
			}
			else
			{
				tc1r_value	= divisor;
				rxclk		= r2;
			}
		}

		if (i)
		{
			d1	= labs(config->baudrate - rxclk);
			d2	= labs(config->baudrate
					- config->baudrate_comp);
		}

		if ((i == 0) || (d1 < d2))
		{
			config->brg1_enable	= list[i].brg1_enable;
			config->brg1_src	= list[i].brg1_src;
			config->ctr1_src	= list[i].ctr1_src;
			config->dpll_div	= list[i].dpll_div;
			config->rxclk_src	= list[i].rxclk_src;
			config->tc1r_value	= tc1r_value;
			config->baudrate_comp	= rxclk;

			if (config->baudrate_comp == config->baudrate)
				break;
		}
	}
}



/******************************************************************************
*
*	Function:	zilog_tx_baud_compute
*
*	Purpose:
*
*		Compute the relavent settings needed to achieve the desired transmit
*		baudrate. The desired baudrate may not be matched exactly. It is up to
*		the caller to decide if the resulting baudrate is acceptable.
*
*	Arguments:
*
*		config	The input parameter are provided here and the computed
*				parameters are stored here.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void zilog_tx_baud_compute(zilog_tx_baud_config_t* config)
{
	static const struct
	{
		unsigned int	ctr0_src		: 2;	// CMCR.CTR0Src
		unsigned int	ctr0_div		: 2;	// HCR.CTR0Div
		unsigned int	ctr0_divisor	: 8;	// 1, 4, 8, 16, 32
		unsigned int	brg0_enable		: 1;	// HCR.BRG0E
		unsigned int	brg0_src		: 2;	// CMCR.BRG0Src
		unsigned int	txclk_src		: 3;	// CMCR.TxCLKSrc
	} list[]	=
	{
		// CTR0							BRG0				TXCLK
		// src		div			divisor	enable	src			src
		{ CTR0_OFF, CTR0_4,		1,		0,		BRG0_TXC,	TXCLK_TXC },// /1
		{ CTR0_TXC, CTR0_4,		4,		0,		BRG0_TXC,	TXCLK_CTR0},// /4
		{ CTR0_TXC, CTR0_8,		8,		0,		BRG0_TXC,	TXCLK_CTR0},// /8
		{ CTR0_TXC, CTR0_16,	16,		0,		BRG0_TXC,	TXCLK_CTR0},// /16
		{ CTR0_TXC, CTR0_32,	32,		0,		BRG0_TXC,	TXCLK_CTR0},// /32

		{ CTR0_OFF, CTR0_4,		1,		1,		BRG0_TXC,	TXCLK_BRG0},// /TC0
		{ CTR0_TXC, CTR0_4,		4,		1,		BRG0_CTR0,	TXCLK_BRG0},// /TC0 /4
		{ CTR0_TXC, CTR0_8,		8,		1,		BRG0_CTR0,	TXCLK_BRG0},// /TC0 /8
		{ CTR0_TXC, CTR0_16,	16,		1,		BRG0_CTR0,	TXCLK_BRG0},// /TC0 /16
		{ CTR0_TXC, CTR0_32,	32,		1,		BRG0_CTR0,	TXCLK_BRG0},// /TC0 /32

		{ 0,		CTR0_32,	0,		0,		0,			0	  }
	};

	long	tc0r_value	= 0;
	long	d1			= -1;
	long	d2			= 0;
	long	divisor;
	int		i;
	long	r1;
	long	r2;
	long	txclk;

	for (i = 0; list[i].ctr0_divisor; i++)
	{
		txclk	= config->txc_rate / list[i].ctr0_divisor;

		if (list[i].brg0_enable)
		{
			divisor	= txclk / config->baudrate;

			if (divisor == 0)
				divisor++;
			else if (divisor >= 65536L)
				divisor	= 65535L;

			r1	= txclk / divisor;
			r2	= txclk / (divisor + 1);
			d1	= labs(config->baudrate - r1);
			d2	= labs(config->baudrate - r2);

			if (d1 < d2)
			{
				tc0r_value	= divisor - 1;
				txclk		= r1;
			}
			else
			{
				tc0r_value	= divisor;
				txclk		= r2;
			}
		}

		if (i)
		{
			d1	= labs(config->baudrate - txclk);
			d2	= labs(config->baudrate
					- config->baudrate_comp);
		}

		if ((i == 0) || (d1 < d2))
		{
			config->brg0_enable	= list[i].brg0_enable;
			config->brg0_src	= list[i].brg0_src;
			config->ctr0_src	= list[i].ctr0_src;
			config->ctr0_div	= list[i].ctr0_div;
			config->txclk_src	= list[i].txclk_src;
			config->tc0r_value	= tc0r_value;
			config->baudrate_comp	= txclk;

			if (config->baudrate_comp == config->baudrate)
				break;
		}
	}
}



/******************************************************************************
*
*	Function:	zilog_mode_config
*
*	Purpose:
*
*		Configure the Zilog channel for the given mode of operation.
*
*	Arguments:
*
*		fd		The handle for the channel to acess.
*
*		normal	Operate in normal mode? If not, then loopback mode is enabled.
*
*		intern	Use Internal Local Loop mode when so indicated? If not then
*				normal Local Loop is used.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int zilog_mode_config(int fd, int normal, int intern)
{
	int	errs;

	if (normal)
		errs	= reg_mod(fd, SIO4_USC_CCAR, 0x000, 0x300);
	else if (intern)
		errs	= reg_mod(fd, SIO4_USC_CCAR, 0x300, 0x300);
	else
		errs	= reg_mod(fd, SIO4_USC_CCAR, 0x200, 0x300);

	return(errs);
}



