// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_rx.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



/******************************************************************************
*
*	Function:	rx_cable_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_cable_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_cable_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_cable_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_cable_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_enable
*
*	Purpose:
*
*		Enable or disable the receiver.
*
*	Arguments:
*
*		fd		The handle to the channel of interest.
*
*		enable	Enable or disable?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int rx_enable(int fd, int enable)
{
	int	errs;
	u32	mask;
	u32	value;

	mask	= SIO4_USC_RMR_RXENAB_ENCODE(SIO4_USC_ENAB_ON_NOW);
	value	= enable ? SIO4_USC_ENAB_ON_NOW : SIO4_USC_ENAB_OFF_NOW;
	value	= SIO4_USC_RMR_RXENAB_ENCODE(value);
	errs	= reg_mod(fd, SIO4_USC_RMR, value, mask);
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_ae_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_fifo_ae_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_ae_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_fifo_ae_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_fifo_ae_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_af_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_fifo_af_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_af_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_fifo_af_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_fifo_af_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_full_cfg_chan
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_fifo_full_cfg_chan() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_full_cfg_chan(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_fifo_full_cfg_chan(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_fifo_full_cfg_chan");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_full_cfg_glb
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_fifo_full_cfg_glb() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_full_cfg_glb(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_fifo_full_cfg_glb(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_fifo_full_cfg_glb");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_size_compute
*
*	Purpose:
*
*		Compute the Rx FIFO. This is done by writing data to the FIFO until it
*		registers as full.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		size	The computed size is recorded here.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_size_compute(int fd, s32* size, int loud)
{
	sio4_async_t	async;
	u32				bs;
	u32				csr;
	int				errs;
	s32				qty		= 0;
	s32				type;

	for (;;)	// A convenience loop.
	{
		size[0]	= 0;
		errs	= feature_test(fd, SIO4_FEATURE_FW_TYPE, &type, loud);

		if (errs)
			break;

		switch (type)
		{
			default:

				errs	= 1;
				printf(	"FAIL <---  (firmware type not recognized: %ld)\n",
						(long) type);
				break;

			case SIO4_FW_TYPE_SYNC:

				errs	= 1;
				printf("SKIPPED  (SYNC firmware type not expected)\n");
				break;

			case SIO4_FW_TYPE_Z16C30:

				errs	+= channel_reset(fd, loud);
				async_block_size(1024, 1024, &bs);
				sio4_async_t_init(&async);
				async.loopback.enable	= 1;
				async.loopback.internal	= 1;
				async.rx.io_mode		= SIO4_IO_MODE_PIO;
				async.tx.io_mode		= SIO4_IO_MODE_PIO;
				errs	+= sio4_async_config(fd, &async, 0, 1);
				break;
		}

		errs	+= fifo_reset(fd, TX_AND_RX_FIFO, 1);
		errs	+= reg_read(fd, -1, 0, SIO4_GSC_CSR, &csr);

		if (errs)
			break;

		if ((csr & 0xF000) == 0xF000)
		{
			qty	= 0;
			gsc_label_fail_text(errs, loud, "No Rx FIFO");
			break;
		}

		csr	= 0xF000;

		for (qty = 2; (errs == 0) && ((csr & 0x4000) == 0x4000);)
		{
			qty	*= 2;

			if (qty > 0xFFFF)
			{
				qty	= 0;
				break;
			}

			errs	+= tx_fifo_ae_config(fd, 16, NULL, loud);
			errs	+= tx_fifo_af_config(fd, 16, NULL, loud);
			errs	+= rx_fifo_ae_config(fd, 16, NULL, loud);
			errs	+= rx_fifo_af_config(fd, qty - 1, NULL, loud);
			errs	+= reg_write(fd, SIO4_GSC_FDR, 0);
			os_sleep_ms(10);	// Sleep for 10ms.
			errs	+= reg_read(fd, -1, 0, SIO4_GSC_CSR, &csr);
		}

		errs	+= fifo_reset(fd, RX_FIFO, loud);
		break;
	}

	if (errs)
		qty	= 0;

	size[0]	= qty;
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_fifo_size
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_fifo_size() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		size	The size is reported here.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_fifo_size(int fd, s32* size, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_fifo_size(fd, size, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_fifo_size");
	return(errs);
}



/******************************************************************************
*
*	Function:	rx_io_mode_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_rx_io_mode_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rx_io_mode_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rx_io_mode_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rx_io_mode_config");
	return(errs);
}



/******************************************************************************
*
*	Function:	rxc_usc_config
*
*	Purpose:
*
*		Put a wrapper around the sio4_rxc_usc_config() call.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		set		The value to apply.
*
*		get		The setting afterwards.
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int rxc_usc_config(int fd, s32 set, s32* get, int loud)
{
	int	errs;
	int	ret;

	ret		= sio4_rxc_usc_config(fd, set, get, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, loud, "sio4_rxc_usc_config");
	return(errs);
}



