// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_reset_channel.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"



//*****************************************************************************
int sio4_reset_channel(int fd, int verbose)
{
	int	errs	= 0;
	int	ret;

	if (verbose)
		gsc_label("Reset Channel");

	ret	= ioctl(fd, SIO4_RESET_CHANNEL);

	if (ret < 0)
		errs	= 1;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}



