// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_open.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	chan_open
*
*	Purpose:
*
*		Implement an open service.
*
*	Arguments:
*
*		device	The index of the device channel to access.
*
*		fd		The file descriptor is stored here.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int chan_open(int device, int* fd, int verbose)
{
	int		brd			= (device - 1) / 4;
	char	buf[64];
	int		chn			= ((device - 1) % 4) + 1;
	int		errs;
	char	name[80]	= "";

	if (verbose)
	{
		sprintf(buf, "Opening SIO4 #%d", device);
		gsc_label(buf);
	}

	if (fd)
	{
		sprintf(name, "/dev/sio4%d", device);
		fd[0]	= open(name, O_RDWR);
		errs	= (fd[0] >= 0) ? 0 : 1;
	}
	else
	{
		errs	= 1;
	}

	if (verbose)
	{
		printf(	"%s  (device %d, channel %d)\n",
				(errs == 0) ? "PASS" : "FAIL <---",
				brd,
				chn);
	}

	return(errs);
}


