// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_label.c $
// $Rev: 42861 $
// $Date: 2018-05-18 11:56:16 -0500 (Fri, 18 May 2018) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



// variables ******************************************************************

static	int	_width	= 0;
static	int	_level	= 0;



/******************************************************************************
*
*	Function:	gsc_label
*
*	Purpose:
*
*		Print a message introducing a test.
*
*	Arguments:
*
*		text	The test name.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label(const char* text)
{
	int	i;
	int	spaces;

	spaces	= _width - strlen(text);
	spaces	= (spaces < 0) ? 0 : spaces;

	for (i = 0; i < _level; i++)
	{
		printf("  ");
		spaces	-= 2;
	}

	printf("%s: %*s", text, spaces, "");
	fflush(stdout);
}



/******************************************************************************
*
*	Function:	gsc_label_init
*
*	Purpose:
*
*		Initialize the label code.
*
*	Arguments:
*
*		width	The default width for the label field.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_init(int width)
{
	_width	= width;
}



/******************************************************************************
*
*	Function:	gsc_label_level_dec
*
*	Purpose:
*
*		Decrease the label indenting.
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_level_dec(void)
{
	_level--;
}



/******************************************************************************
*
*	Function:	gsc_label_level_inc
*
*	Purpose:
*
*		Increase the label indenting.
*
*	Arguments:
*
*		None.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_level_inc(void)
{
	_level++;
}



/******************************************************************************
*
*	Function:	gsc_label_fail_func
*
*	Purpose:
*
*		Report a failure for the given function if there are errors and loud is
*		enabled.
*
*	Arguments:
*
*		errs	Have any errors already been reported?
*
*		loud	Work verbosely?
*
*		func	The name of the function that returned the error.
*
*	Returned:
*
*		1		This is an error condition.
*
******************************************************************************/

int gsc_label_fail_func(int errs, int loud, const char* func)
{
	if ((errs) && (loud) && (func))
		printf("FAIL <---  (%s(), errno %d)\n", func, errno);

	return(1);
}



/******************************************************************************
*
*	Function:	gsc_label_fail_text
*
*	Purpose:
*
*		Report a failure with the given text if there are errors and loud is
*		enabled.
*
*	Arguments:
*
*		errs	Have any errors already been reported?
*
*		loud	Work verbosely?
*
*		text	The text to report.
*
*	Returned:
*
*		1		This is an error condition.
*
******************************************************************************/

int gsc_label_fail_text(int errs, int loud, const char* text)
{
	if ((errs) && (loud) && (text))
		printf("FAIL <---  (%s)\n", text);

	return(1);
}



/******************************************************************************
*
*	Function:	gsc_label_fail_value
*
*	Purpose:
*
*		Report a failure with the given value if there are errors and loud is
*		enabled.
*
*	Arguments:
*
*		errs	Have any errors already been reported?
*
*		loud	Work verbosely?
*
*		value	The value to report.
*
*	Returned:
*
*		1		This is an error condition.
*
******************************************************************************/

int gsc_label_fail_value(int errs, int loud, long value)
{
	if ((errs) && (loud))
	{
		printf(	"FAIL <---  (invalid value: %ld/0x%lX)\n",
			(long) value,
			(long) value);
	}

	return(1);
}



/******************************************************************************
*
*	Function:	gsc_label_indent
*
*	Purpose:
*
*		Print the space that preceeds the label.
*
*	Arguments:
*
*		delta	Adjust the indenting by this amount.
*
*	Returned:
*
*		The number of spaces printed.
*
******************************************************************************/

int gsc_label_indent(int delta)
{
	int	i;
	int	spaces	= 0;

	for (i = 0; i < (_level + delta); i++, spaces += 2)
		printf("  ");

	fflush(stdout);
	return(spaces);
}



/******************************************************************************
*
*	Function:	gsc_label_index
*
*	Purpose:
*
*		Print a message introducing a test. If the index number is >= 0, then
*		append the index number to the label.
*
*	Arguments:
*
*		text	The test name.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_index(const char* text, int index)
{
	char	buf[128];

	strcpy(buf, text);

	if (index >= 0)
		sprintf(buf + strlen(buf), " #%d", index);

	gsc_label(buf);
}



/******************************************************************************
*
*	Function:	gsc_label_long_comma
*
*	Purpose:
*
*		Print a value with commas.
*
*	Arguments:
*
*		value	The positive value to print.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_long_comma(long long value)
{
	char	buf[32];
	int		i;
	int		len;

	if (value < 0)
	{
		printf("-");
		value	= -value;
	}

	sprintf(buf, "%lld", value);
	len	= strlen(buf);

	for (i = len; i; i--)
	{
		if (i == len)
			;
		else if ((i % 3) == 0)
			printf(",");

		printf("%c", buf[len - i]);
	}
}



/******************************************************************************
*
*	Function:	gsc_label_suffix
*
*	Purpose:
*
*		Print a message introducing a test, but withg a suffix other than ":".
*
*	Arguments:
*
*		text	The test name. If this is NULL, then we just output spaces.
*
*		siffix	The suffix to use in place of the ":" sequence.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void gsc_label_suffix(const char* text, const char* suffix)
{
	int	spaces;

	if (text)
	{
		spaces	= _width - strlen(text);
		spaces	= (spaces < 0) ? 0 : spaces;
		spaces	-= gsc_label_indent(0);
		printf("%s%s %*s", text, suffix, spaces, "");
	}
	else
	{
		spaces	= _width;
		spaces	= (spaces < 0) ? 0 : spaces;
		spaces	-= gsc_label_indent(0);
		printf("  %*s", spaces, "");
	}

	fflush(stdout);
}


