// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_fw_type_config.c $
// $Rev: 42861 $
// $Date: 2018-05-18 11:56:16 -0500 (Fri, 18 May 2018) $

// SIO4: Utilities: source file

#include "main.h"



//*****************************************************************************
int sio4_fw_type_config(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Firmware Type Config", index);

	ret		= sio4_ioctl(fd, SIO4_FW_TYPE_CONFIG, &set);
	errs	= (ret < 0) ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case SIO4_FW_TYPE_CONFIG_SYNC:

			ptr	= "SYNC";
			break;

		case SIO4_FW_TYPE_CONFIG_Z16C30:

			ptr	= "Z16C30";
			break;
	}

	if (verbose == 0)
		;
	else
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


