// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_feature.c $
// $Rev: 53094 $
// $Date: 2023-06-13 10:21:23 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: source file

#include "main.h"



//*****************************************************************************
int feature_test_query(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	s32			query	= set;
	int			ret;
	s32			tmp;

	switch (query)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Feature Query Error (#%ld)", (long) query);
			break;

		case SIO4_FEATURE_COUNT:				ptr	= "Feature Count";				break;
		case SIO4_FEATURE_BOARD_RESET:			ptr	= "Board Reset";				break;
		case SIO4_FEATURE_REG_BSR:				ptr	= "Board Status Register";		break;
		case SIO4_FEATURE_REG_FCR:				ptr	= "FIFO Count Register";		break;
		case SIO4_FEATURE_REG_FSR:				ptr	= "FIFO Size Register";			break;
		case SIO4_FEATURE_REG_FR:				ptr	= "Features Register";			break;
		case SIO4_FEATURE_RX_FIFO_FULL_CFG_GLB:	ptr	= "Rx FIFO Full Cfg Glb";		break;
		case SIO4_FEATURE_REG_PSRCR:			ptr	= "Pin Source Register";		break;
		case SIO4_FEATURE_REG_PSTSR:			ptr	= "Pin Status Register";		break;
		case SIO4_FEATURE_IRQ_32:				ptr	= "32 Interrupts";				break;
		case SIO4_FEATURE_OSC_CHIP:				ptr	= "Oscillator Chip";			break;
		case SIO4_FEATURE_OSC_PER_CHANNEL:		ptr	= "Oscillator Per Channel";		break;
		case SIO4_FEATURE_OSC_PROGRAM:			ptr	= "Oscillator Programm";		break;
		case SIO4_FEATURE_OSC_MEASURE:			ptr	= "Oscillator Measure";			break;
		case SIO4_FEATURE_MODEL_SYNC:			ptr	= "SYNC Model";					break;
		case SIO4_FEATURE_MODEL_Z16C30:			ptr	= "Z16C30 Model";				break;
		case SIO4_FEATURE_MP:					ptr	= "Multi-Prot (Xcvr)";			break;
		case SIO4_FEATURE_MP_CHIP:				ptr	= "MP Chip (Xcvr)";				break;
		case SIO4_FEATURE_MP_PROGRAM:			ptr	= "MP Programmable";			break;
		case SIO4_FEATURE_DMDMA_SCD:			ptr	= "Single Cycle Disable";		break;
		case SIO4_FEATURE_OSC_PD_MAX:			ptr	= "Osc Post Divider";			break;
		case SIO4_FEATURE_REG_PORD2R:			ptr	= "Prog Osc 2 Register";		break;
		case SIO4_FEATURE_FW_TYPE:				ptr	= "Default Firmware Type";		break;
		case SIO4_FEATURE_SIO4_TYPE:			ptr	= "SIO4 Type";					break;
		case SIO4_FEATURE_LEGACY_CABLE:			ptr	= "Legacy Cable Interface";		break;
		case SIO4_FEATURE_USER_JUMPER_SENSE:	ptr	= "User Jumper Sense";			break;
		case SIO4_FEATURE_USER_JUMPER_QTY:		ptr	= "User Jumper Count";			break;
		case SIO4_FEATURE_REG_CCR:				ptr	= "Register: CCR";				break;
		case SIO4_FEATURE_REG_TSR:				ptr	= "Register: TSR";				break;
		case SIO4_FEATURE_REG_IELR:				ptr	= "IRQ Edge/Level Register";	break;
		case SIO4_FEATURE_REG_IHLR:				ptr	= "IRQ High/Low Register";		break;
		case SIO4_FEATURE_REG_SBR:				ptr	= "Sync Byte Register";			break;
		case SIO4_FEATURE_REG_GPIOSR:			ptr	= "Register: GPIOSR";			break;
		case SIO4_FEATURE_REG_IOCR:				ptr	= "Register: IOCT";				break;
		case SIO4_FEATURE_REG_RCR:				ptr	= "Register: RCR";				break;
		case SIO4_FEATURE_REG_TCR:				ptr	= "Register: TCR";				break;
		case SIO4_FEATURE_REG_FTR:				ptr	= "Firmware Type Register";		break;
		case SIO4_FEATURE_FORM_FACTOR:			ptr	= "Form Factor";				break;
		case SIO4_FEATURE_BUS_SPEED:			ptr	= "PCI Bus Speed";				break;
		case SIO4_FEATURE_BUS_WIDTH:			ptr	= "PCI Bus Width";				break;
		case SIO4_FEATURE_INDEX_CHANNEL:		ptr	= "Channel Index";				break;
		case SIO4_FEATURE_CHANNEL_QTY:			ptr	= "Channel Count";				break;
		case SIO4_FEATURE_FIFO_SIZE_RX:			ptr	= "Rx FIFO Size";				break;
		case SIO4_FEATURE_FIFO_SIZE_TX:			ptr	= "Tx FIFO Size";				break;
		case SIO4_FEATURE_FIFO_SIZE_TOTAL:		ptr	= "Total FIFO Size";			break;
		case SIO4_FEATURE_INDEX_SUBDEVICE:		ptr	= "Subdevice Index";			break;
		case SIO4_FEATURE_REG_PCR:				ptr	= "Prog Clock Reg";				break;
		case SIO4_FEATURE_REG_POCSR:			ptr	= "Osc Register: POCSR";		break;
		case SIO4_FEATURE_REG_PORAR:			ptr	= "Osc Register: PORAR";		break;
		case SIO4_FEATURE_REG_PORDR:			ptr	= "Osc Register: PORDR";		break;
		case SIO4_FEATURE_REG_PSRCR_BITS:		ptr	= "PSRCR Bits";					break;
		case SIO4_FEATURE_USER_JUMPER_VAL:		ptr	= "User Jumper Value";			break;
		case SIO4_FEATURE_RX_FIFO_FULL_CFG:		ptr	= "Rx FIFO Full Cfg Chan";		break;
		case SIO4_FEATURE_MODEL_BASE:			ptr	= "Base Model Number";			break;
		case SIO4_FEATURE_REG_PSTSR_BITS:		ptr	= "PSRCR Bits";					break;
		case SIO4_FEATURE_DEVICE_QTY:			ptr	= "Devices Per Board";			break;
		case SIO4_FEATURE_FIFO_SPACE_CFG:		ptr	= "FIFO Space Cfg";				break;
		case SIO4_FEATURE_INDEX_DEVICE:			ptr	= "Device Index";				break;
		case SIO4_FEATURE_LED_CHANNEL:			ptr	= "Channel LEDs";				break;
		case SIO4_FEATURE_LED_MAIN:				ptr	= "Main LEDs";					break;
		case SIO4_FEATURE_RX_FIFO_OVERRUN:		ptr	= "Rx FIFO Overrun";			break;
		case SIO4_FEATURE_RX_FIFO_UNDERRUN:		ptr	= "Rx FIFO Underrun";			break;
		case SIO4_FEATURE_RX_STATUS_WORD:		ptr	= "Rx Status Word";				break;
		case SIO4_FEATURE_TIME_STAMP:			ptr	= "Time Stamp";					break;
		case SIO4_FEATURE_TX_FIFO_EMPTY_CFG:	ptr	= "Tx FIFO Empty Cfg";			break;
		case SIO4_FEATURE_TX_FIFO_OVERRUN:		ptr	= "Tx FIFO Overrun";			break;
		case SIO4_FEATURE_MP_BITMAP:			ptr	= "Multi-Protocol Bitmap";		break;
		case SIO4_FEATURE_INDEX_BOARD:			ptr	= "Board Index";				break;
		case SIO4_FEATURE_FW_TYPE_CONFIG:		ptr	= "Firmware Type Config";		break;
	}

	if (verbose)
		gsc_label_index(ptr, index);

	ret		= ioctl(fd, SIO4_FEATURE_TEST, &set);
	errs	+= ret ? 1 : 0;

	switch (query)
	{
		default:

			errs++;
			sprintf(buf, "%ld", (long) set);
			break;

		case SIO4_FEATURE_BOARD_RESET:
		case SIO4_FEATURE_REG_BSR:
		case SIO4_FEATURE_REG_FCR:
		case SIO4_FEATURE_REG_FSR:
		case SIO4_FEATURE_REG_FR:
		case SIO4_FEATURE_RX_FIFO_FULL_CFG_GLB:
		case SIO4_FEATURE_REG_PSRCR:
		case SIO4_FEATURE_REG_PSTSR:
		case SIO4_FEATURE_DMDMA_SCD:
		case SIO4_FEATURE_LEGACY_CABLE:
		case SIO4_FEATURE_REG_PORD2R:
		case SIO4_FEATURE_REG_CCR:
		case SIO4_FEATURE_REG_TSR:
		case SIO4_FEATURE_REG_IELR:
		case SIO4_FEATURE_REG_IHLR:
		case SIO4_FEATURE_REG_SBR:
		case SIO4_FEATURE_REG_GPIOSR:
		case SIO4_FEATURE_REG_IOCR:
		case SIO4_FEATURE_REG_RCR:
		case SIO4_FEATURE_REG_TCR:
		case SIO4_FEATURE_REG_FTR:
		case SIO4_FEATURE_REG_PCR:
		case SIO4_FEATURE_REG_POCSR:
		case SIO4_FEATURE_REG_PORAR:
		case SIO4_FEATURE_REG_PORDR:
		case SIO4_FEATURE_RX_FIFO_FULL_CFG:
		case SIO4_FEATURE_FIFO_SPACE_CFG:
		case SIO4_FEATURE_RX_FIFO_OVERRUN:
		case SIO4_FEATURE_RX_FIFO_UNDERRUN:
		case SIO4_FEATURE_RX_STATUS_WORD:
		case SIO4_FEATURE_TIME_STAMP:
		case SIO4_FEATURE_TX_FIFO_EMPTY_CFG:
		case SIO4_FEATURE_TX_FIFO_OVERRUN:
		case SIO4_FEATURE_FW_TYPE_CONFIG:

			sprintf(buf, "%s", set ? "Supported" : "Not Supported");
			break;

		case SIO4_FEATURE_OSC_PER_CHANNEL:
		case SIO4_FEATURE_OSC_PROGRAM:
		case SIO4_FEATURE_OSC_MEASURE:
		case SIO4_FEATURE_MODEL_SYNC:
		case SIO4_FEATURE_MODEL_Z16C30:
		case SIO4_FEATURE_MP:
		case SIO4_FEATURE_MP_PROGRAM:

			sprintf(buf, "%s", set ? "Yes" : "No");
			break;

		case SIO4_FEATURE_IRQ_32:

			sprintf(buf, "%s", set ? "Yes (32)" : "No (16)");
			break;

		case SIO4_FEATURE_COUNT:
		case SIO4_FEATURE_USER_JUMPER_QTY:
		case SIO4_FEATURE_INDEX_CHANNEL:
		case SIO4_FEATURE_CHANNEL_QTY:
		case SIO4_FEATURE_INDEX_SUBDEVICE:
		case SIO4_FEATURE_DEVICE_QTY:
		case SIO4_FEATURE_INDEX_DEVICE:
		case SIO4_FEATURE_LED_CHANNEL:
		case SIO4_FEATURE_LED_MAIN:
		case SIO4_FEATURE_INDEX_BOARD:

			sprintf(buf, "%ld", (long) set);
			break;

		case SIO4_FEATURE_OSC_PD_MAX:
		case SIO4_FEATURE_BUS_WIDTH:

			sprintf(buf, "%ld-bits", (long) set);
			break;

		case SIO4_FEATURE_BUS_SPEED:

			sprintf(buf, "%ld MHz", (long) set);
			break;

		case SIO4_FEATURE_REG_PSRCR_BITS:
		case SIO4_FEATURE_USER_JUMPER_VAL:
		case SIO4_FEATURE_REG_PSTSR_BITS:
		case SIO4_FEATURE_MP_BITMAP:

			sprintf(buf, "0x%lX", (long) set);
			break;

		case SIO4_FEATURE_FIFO_SIZE_RX:
		case SIO4_FEATURE_FIFO_SIZE_TX:
		case SIO4_FEATURE_FIFO_SIZE_TOTAL:


			ptr	= "";
			tmp	= set;

			if ((tmp) && ((tmp % 1024) == 0))
			{
				ptr	= "K";
				tmp	/= 1024;
			}

			sprintf(buf, "%ld%s Bytes", (long) tmp, ptr);
			break;

		case SIO4_FEATURE_OSC_CHIP:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_OSC_CHIP_FIXED:		strcpy(buf, "Fixed");			break;
				case SIO4_OSC_CHIP_IDC2053B:	strcpy(buf, "IDC2053B (1x)");	break;
				case SIO4_OSC_CHIP_IDC2053B_4:	strcpy(buf, "IDC2053B (4x)");	break;
				case SIO4_OSC_CHIP_CY22393:		strcpy(buf, "CY22393 (1x)");	break;
				case SIO4_OSC_CHIP_CY22393_2:	strcpy(buf, "CY22393 (2x)");	break;
				case SIO4_OSC_CHIP_UNKNOWN:		strcpy(buf, "Unknown");			break;
			}

			break;

		case SIO4_FEATURE_MP_CHIP:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_MP_CHIP_FIXED:	strcpy(buf, "Fixed");	break;
				case SIO4_MP_CHIP_SP508:	strcpy(buf, "SP508");	break;
				case SIO4_MP_CHIP_UNKNOWN:	strcpy(buf, "Unknown");	break;
			}

			break;

		case SIO4_FEATURE_FW_TYPE:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_FW_TYPE_CONFIG_SYNC:		strcpy(buf, "SYNC");	break;
				case SIO4_FW_TYPE_CONFIG_Z16C30:	strcpy(buf, "Z16C30");	break;
			}

			break;

		case SIO4_FEATURE_SIO4_TYPE:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_TYPE_SIO4:		strcpy(buf, "SIO4");		break;
				case SIO4_TYPE_SIO4A:		strcpy(buf, "SIO4A");		break;
				case SIO4_TYPE_SIO4AR:		strcpy(buf, "SIO4AR");		break;
				case SIO4_TYPE_SIO4AHRM:	strcpy(buf, "SIO4AHRM");	break;
				case SIO4_TYPE_SIO4B:		strcpy(buf, "SIO4B");		break;
				case SIO4_TYPE_SIO4BX:		strcpy(buf, "SIO4BX");		break;
				case SIO4_TYPE_SIO4BXR:		strcpy(buf, "SIO4BXR");		break;
				case SIO4_TYPE_SIO8BXS:		strcpy(buf, "SIO8BXS");		break;
				case SIO4_TYPE_SIO4BX2:		strcpy(buf, "SIO4BX2");		break;
				case SIO4_TYPE_SIO8BX2:		strcpy(buf, "SIO8BX2");		break;
			}

			break;

		case SIO4_FEATURE_MODEL_BASE:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_MODEL_SIO4:			strcpy(buf, "SIO4");			break;
				case SIO4_MODEL_SIO4A:			strcpy(buf, "SIO4A");			break;
				case SIO4_MODEL_SIO4A_SYNC:		strcpy(buf, "SIO4A_SYNC");		break;
				case SIO4_MODEL_SIO4AR:			strcpy(buf, "SIO4AR");			break;
				case SIO4_MODEL_SIO4AR_SYNC:	strcpy(buf, "SIO4AR_SYNC");		break;
				case SIO4_MODEL_SIO4AHRM:		strcpy(buf, "SIO4AHRM");		break;
				case SIO4_MODEL_SIO4AHRM_SYNC:	strcpy(buf, "SIO4AHRM_SYNC");	break;
				case SIO4_MODEL_SIO4B:			strcpy(buf, "SIO4B");			break;
				case SIO4_MODEL_SIO4B_SYNC:		strcpy(buf, "SIO4B_SYNC");		break;
				case SIO4_MODEL_SIO4BX:			strcpy(buf, "SIO4BX");			break;
				case SIO4_MODEL_SIO4BX_SYNC:	strcpy(buf, "SIO4BX_SYNC");		break;
				case SIO4_MODEL_SIO4BXR:		strcpy(buf, "SIO4BXR");			break;
				case SIO4_MODEL_SIO4BXR_SYNC:	strcpy(buf, "SIO4BXR_SYNC");	break;
				case SIO4_MODEL_SIO8BXS:		strcpy(buf, "SIO8BXS");			break;
				case SIO4_MODEL_SIO8BXS_SYNC:	strcpy(buf, "SIO8BXS_SYNC");	break;
				case SIO4_MODEL_SIO4BX2:		strcpy(buf, "SIO4BX2");			break;
				case SIO4_MODEL_SIO4BX2_SYNC:	strcpy(buf, "SIO4BX2_SYNC");	break;
				case SIO4_MODEL_SIO8BX2:		strcpy(buf, "SIO8BX2");			break;
				case SIO4_MODEL_SIO8BX2_SYNC:	strcpy(buf, "SIO8BX2_SYNC");	break;
			}

			break;

		case SIO4_FEATURE_USER_JUMPER_SENSE:

				sprintf(buf, "%d = Jumper On", (int) set);
				break;

		case SIO4_FEATURE_FORM_FACTOR:

			switch (set)
			{
				default:

					errs++;
					sprintf(buf, "Invalid option: %ld", (long) set);
					break;

				case SIO4_FORM_FACTOR_PCI:		strcpy(buf, "PCI (32-bit)");		break;
				case SIO4_FORM_FACTOR_PMC:		strcpy(buf, "PMC (32-bit)");		break;
				case SIO4_FORM_FACTOR_CPCI:		strcpy(buf, "Compact PCI");			break;
				case SIO4_FORM_FACTOR_PC104P:	strcpy(buf, "PC/104+");				break;
				case SIO4_FORM_FACTOR_PCIE:		strcpy(buf, "PCI Express");			break;
				case SIO4_FORM_FACTOR_XMC:		strcpy(buf, "XMC");					break;
				case SIO4_FORM_FACTOR_PCI66:	strcpy(buf, "PCI (66 MHz)");		break;
				case SIO4_FORM_FACTOR_PCIE4:	strcpy(buf, "PCI Express (4x)");	break;
				case SIO4_FORM_FACTOR_PMC66:	strcpy(buf, "PMC (66 MHz)");		break;
				case SIO4_FORM_FACTOR_UNKNOWN:	strcpy(buf, "Unknown");				break;
			}

			break;
	}

	if (verbose)
	{
		if (errs)
			printf("FAIL <---  (%s)\n", buf);
		else
			printf("%s\n", buf);
	}

	if (get)
		get[0]	= set;

	return(errs);
}



//*****************************************************************************
int feature_test(int fd, s32 set, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, set, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "sio4_feature_test");
	return(errs);
}



//*****************************************************************************
int feature_test__count(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_COUNT, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_COUNT");
	return(errs);
}



//*****************************************************************************
int feature_test__fifo_size(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_REG_FSR, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_REG_FSR");
	return(errs);
}



//*****************************************************************************
int feature_test__mp(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test( fd,SIO4_FEATURE_MP, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_MP");
	return(errs);
}



//*****************************************************************************
int feature_test__osc_program(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_OSC_PROGRAM, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_OSC_PROGRAM");
	return(errs);
}



//*****************************************************************************
int feature_test__bcr_scd(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_DMDMA_SCD, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_BCR_SCD");
	return(errs);
}



//*****************************************************************************
int feature_test__sync_model(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_MODEL_SYNC, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_MODEL_SYNC");
	return(errs);
}



//*****************************************************************************
int feature_test__z16c30_model(int fd, s32* result, int verbose)
{
	int	errs;
	int	ret;

	ret		= sio4_feature_test(fd, SIO4_FEATURE_MODEL_Z16C30, result, 0);
	errs	= (ret < 0) ? 1 : 0;
	gsc_label_fail_func(errs, verbose, "SIO4_FEATURE_MODEL_Z16C30");
	return(errs);
}



