// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/utils/util_dcedte.c $
// $Rev: 42861 $
// $Date: 2018-05-18 11:56:16 -0500 (Fri, 18 May 2018) $

// SIO4: Utilities: source file

#include "main.h"

// Useless code for the validation script.
//	if (verbose
//	if (verbose



/******************************************************************************
*
*	Function:	dcedte_config
*
*	Purpose:
*
*		Compute the transfer block based on the FIFO sizes.
*
*	Arguments:
*
*		fd		The handles to access all four channels.
*
*		enable	Enable DCE/DTE mode, if available?
*
*		dce		Use DCE mode? If not, then DTE is used.
*
*		loopbk	Enable loopback operation?
*
*		loud	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

int dcedte_config(int fd, int enable, int dce, int loopbk, int loud)
{
	int	errs;
	s32	feature;
	u32	mask;
	u32	value;

	for (;;)	// A convenience loop.
	{
		errs	= sio4_feature_test(fd, SIO4_FEATURE_REG_PSRCR, &feature, loud);

		if ((errs) || (feature == SIO4_FEATURE_NO))
			break;

		mask	= SIO4_GSC_PSRCR_DCE_MODE
				| SIO4_GSC_PSRCR_DCEDTE_ENABLE
				| SIO4_GSC_PSRCR_LB_ENABLE;
		value	= enable ? SIO4_GSC_PSRCR_DCEDTE_ENABLE : 0;
		value	|= dce ? SIO4_GSC_PSRCR_DCE_MODE : 0;
		value	|= loopbk ? SIO4_GSC_PSRCR_LB_ENABLE : 0;
		errs	= reg_mod(fd, SIO4_GSC_PSRCR, value, mask);
		break;
	}

	return(errs);
}



