// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/sync/samples/txrate/utils.c $
// $Rev: 53087 $
// $Date: 2023-06-13 10:12:24 -0500 (Tue, 13 Jun 2023) $

// SIO4: SYNC Protocol Library: Sample Application: source file

#include "main.h"



// variables ******************************************************************




//*****************************************************************************
int channels_close(const args_t* args)
{
	char	buf[80];
	int		chan;
	int		errs	= 0;
	int		i;
	int		ret;

	gsc_label("Closing Channels");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i <= 3; i++)
	{
		chan	= args->index * 4 + 1 + i;
		sprintf(buf, "SIO4 %d", chan);
		gsc_label(buf);

		if (args->fd[i] < 0)
		{
			printf("SKIP\n");
			continue;
		}

		ret	= sio4_close(args->fd[i]);

		if (ret < 0)
		{
			errs++;
			printf("FAIL <---\n");
		}
		else
		{
			printf("PASS\n");
		}
	}

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int channels_open(const args_t* args, int* fd)
{
	char	buf[80];
	int		chan;
	int		errs	= 0;
	int		i;

	gsc_label("Opening Channels");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i <= 3; i++)
	{
		chan	= args->index * 4 + 1 + i;
		sprintf(buf, "SIO4 %d", chan);
		gsc_label(buf);

		errs	= sio4_open(chan, &fd[i]);

		if (errs)
			printf("FAIL <---\n");
		else
			printf("PASS\n");
	}

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
int firmware_types(const args_t* args, int* skip)
{
	char	buf[80];
	int		chan;
	int		errs	= 0;
	s32		fw_type;
	int		i;
	int		ret;

	gsc_label("Firmware Types");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i <= 3; i++)
	{
		chan	= args->index * 4 + 1 + i;
		sprintf(buf, "SIO4 %d", chan);
		gsc_label(buf);

		fw_type	= SIO4_FW_TYPE_CONFIG_READ;
		ret		= ioctl(args->fd[i], SIO4_FW_TYPE_CONFIG, &fw_type);

		if (ret < 0)
		{
			printf("FAIL <---\n");
			errs++;
			continue;
		}

		switch (fw_type)
		{
			default:

				errs++;
				printf("FAIL <---  (unknown type: %d)\n", (int) fw_type);
				break;

			case SIO4_FW_TYPE_CONFIG_SYNC:

				printf("PASS  (SYNC)\n");
				break;

			case SIO4_FW_TYPE_CONFIG_Z16C30:

				skip[0]	= 1;
				printf("SKIP <---  (Z16C30)\n");
				break;
		}
	}

	gsc_label_level_dec();
	return(errs);
}



//*****************************************************************************
u32 os_reg_mem_rx_u32(dev_data_t* dev, VADDR_T vaddr)
{
	u32	value;

	if (vaddr == SIO4_GSC_POCSR)
	{
		if		(poscr & 0x02)	value	= calc_measure(dev, 0, 0, 0);
		else if (poscr & 0x04)	value	= calc_measure(dev, 1, 0, 0);
		else if (poscr & 0x08)	value	= calc_measure(dev, 2, 0, 0);
		else if (poscr & 0x10)	value	= calc_measure(dev, 3, 0, 0);
		else					value	= 0;

		value	= ((value / 10) << 8)
				| SIO4_GSC_POCSR_PRG_DONE
				| SIO4_GSC_POCSR_MSR_DONE;
	}
	else
	{
		value	= 0;
	}

	return(value);
}



//*****************************************************************************
void os_reg_mem_tx_u32(dev_data_t* dev, VADDR_T vaddr, u32 value)
{
	if (vaddr == SIO4_GSC_POCSR)
		poscr	= value;
}



//*****************************************************************************
int os_time_tick_rate(void)
{
	return(1000);
}



//*****************************************************************************
void os_time_tick_sleep(int ticks)
{
}



//*****************************************************************************
void os_time_us_delay(long us)
{
}



//*****************************************************************************
int osc_types(const args_t* args, int* skip)
{
	char	buf[80];
	int		chan;
	int		errs	= 0;
	int		i;
	s32		get;
	int		ret;

	gsc_label("Oscillator Types");
	printf("\n");
	gsc_label_level_inc();

	for (i = 0; i <= 3; i++)
	{
		chan	= args->index * 4 + 1 + i;
		sprintf(buf, "SIO4 %d", chan);
		gsc_label(buf);

		get	= SIO4_FEATURE_OSC_CHIP;
		ret	= ioctl(args->fd[i], SIO4_FEATURE_TEST, &get);

		if (ret < 0)
		{
			printf("FAIL <---\n");
			errs++;
			continue;
		}

		switch (get)
		{
			default:
			case SIO4_OSC_CHIP_UNKNOWN:

				errs++;
				skip[0]	= 1;
				printf("FAIL  (unknown oscillator: %d)\n", (int) get);
				break;

			case SIO4_OSC_CHIP_FIXED:

				skip[0]	= 1;
				printf("SKIP <---  (fixed)\n");
				break;

			case SIO4_OSC_CHIP_IDC2053B:

				skip[0]	= 1;
				printf("SKIP <---  (IDC2053B)\n");
				break;

			case SIO4_OSC_CHIP_IDC2053B_4:

				skip[0]	= 1;
				printf("SKIP <---  (IDC2053B/4x)\n");
				break;

			case SIO4_OSC_CHIP_CY22393:

				printf("PASS  (CY22393)\n");
				break;

			case SIO4_OSC_CHIP_CY22393_2:

				printf("PASS  (CY22393/2x)\n");
				break;
		}
	}

	gsc_label_level_dec();
	return(errs);
}



// ****************************************************************************
void print_long(long l)
{
	char	buf1[32];
	char	buf2[32]	= "";
	char*	src			= buf1;
	char*	dst			= buf2;

	sprintf(buf1, "%ld", l);

	for (;src[0];)
	{
		if (src == buf1)
		{
		}
		else if ((strlen(src) % 3) == 0)
		{
			strcpy(dst, ",");
			dst++;
		}

		dst[0]	= src[0];
		dst[1]	= 0;
		dst++;
		src++;
	}

	printf("%s", buf2);
}


