// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/sync/lib/main.c $
// $Rev: 53089 $
// $Date: 2023-06-13 10:15:12 -0500 (Tue, 13 Jun 2023) $

// SIO4: SYNC Protocol Library: source file

#include "main.h"



//*****************************************************************************
static int _fw_type_get(int fd, __s32* fw)
{
	int	errs;
	int	ret;

	fw[0]	= -1;
	ret		= ioctl(fd, SIO4_FW_TYPE_CONFIG, fw);
	errs	= (ret == 0) ? 0 : 1;
	return(errs);
}



/******************************************************************************
*
*	Function:	sync_reg_mod
*
*	Purpose:
*
*		Perform a read-modify-write operation on an SIO4-SYNC register.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		reg		The register to access.
*
*		value	Record the value here.
*
*		mask	The set of bits to modity.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sync_reg_mod(int fd, __u32 reg, __u32 value, __u32 mask)
{
	int		errs;
	__s32	fw;
	int		ret;

	errs	= _fw_type_get(fd, &fw);

	if (errs)
	{
		ret	= -EIO;
	}
	else if (fw != SIO4_FW_TYPE_CONFIG_SYNC)
	{
		ret	= EINVAL;
	}
	else
	{
		ret	= sio4_reg_mod(fd, reg, value, mask);
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	sync_reg_read
*
*	Purpose:
*
*		Read a register if the SIO4 is a SYNC device.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		reg		The register to access.
*
*		value	Record the value here.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sync_reg_read(int fd, __u32 reg, __u32* value)
{
	int		errs;
	__s32	fw;
	int		ret;

	errs	= _fw_type_get(fd, &fw);

	if (errs)
		ret	= -EIO;
	else if (fw != SIO4_FW_TYPE_CONFIG_SYNC)
		ret	= EINVAL;
	else
		ret	= sio4_reg_read(fd, reg, value);

	return(ret);
}



/******************************************************************************
*
*	Function:	sync_reg_write
*
*	Purpose:
*
*		Write a value to an SIO4 SYNC register.
*
*	Arguments:
*
*		fd		The file rescriptor for the SIO4 to access.
*
*		reg		The register to access.
*
*		value	The value to write.
*
*	Returned:
*
*		0		All went well.
*		> 0		An appropriate error status.
*
******************************************************************************/

int sync_reg_write(int fd, __u32 reg, __u32 value)
{
	int		errs;
	__s32	fw;
	int		ret;

	errs	= _fw_type_get(fd, &fw);

	if (errs)
		ret	= -EIO;
	else if (fw != SIO4_FW_TYPE_CONFIG_SYNC)
		ret	= EINVAL;
	else
		ret	= sio4_reg_write(fd, reg, value);

	return(ret);
}



