#include <errno.h>
#include <stdio.h>

#include "sio4_sync_dsl.h"

int sio4_sync_gpio_mod(int fd, __u32 value, __u32 mask, int verbose)
{
	int			status;
	const char*	str	= "sio4_sync_gpio_rx";
	__u32		v;

	status	= sio4_sync_gpio_rx(fd, &v);

	if (status == 0)
	{
		value	= (value & mask) | (v & ~mask);
		status	= sio4_sync_gpio_tx(fd, value);
		str		= "sio4_sync_gpio_tx";
	}

	if ((verbose) && (status == -1))
		printf("%s() failure, errno = %d\n", str, errno);

	return(status);
}
