// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/write_register.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const struct
	{
		const char*	name;
		u32			reg;
		u32			value;
		u32			mask;
	} list[]	=
	{
		// name		reg				value		mask
		{ "TAR",	SIO4_GSC_TAR,	0xAAAAAAAA,	0xFFFFFFFF	},
		{ "TAR",	SIO4_GSC_TAR,	0x55555555,	0xFFFFFFFF	},

		{ "RAR",	SIO4_GSC_RAR,	0xAAAAAAAA,	0xFFFFFFFF	},
		{ "RAR",	SIO4_GSC_RAR,	0x55555555,	0xFFFFFFFF	},
	};

	int				errs	= 0;
	int				i;
	int				j;
	REGISTER_PARAMS	parm;

	for (i = 0; i < SIZEOF_ARRAY(list); i++)
	{
		parm.u32RegisterNumber	= list[i].reg;
		parm.u32Value			= list[i].value;
		j	= ioctl(fd, SIO4_WRITE_REGISTER, (void*) &parm);

		if (j)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, %s, ioctl() failure, errno %d)\n",
					__LINE__,
					i,
					list[i].name,
					errno);
			break;
		}

		// Now read the register and verify the bits of interest.
		j	= ioctl(fd, SIO4_READ_REGISTER, (void*) &parm);

		if (j)
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, %s, ioctl() failure, errno %d)\n",
					__LINE__,
					i,
					list[i].name,
					errno);
			break;
		}

		if ((list[i].value & list[i].mask) != (parm.u32Value & list[i].mask))
		{
			errs++;
			printf(	"FAIL <---  (%d. i %d, %s, mask 0x%lX, got 0x%lX, expected 0x%lX)\n",
					__LINE__,
					i,
					list[i].name,
					(long) list[i].mask,
					(long) parm.u32Value,
					(long) list[i].value);
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int write_register_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_WRITE_REGISTER");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


