// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/set_xmt_isochr_prot.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd							arg	reg				mask	value
		{ SERVICE_BY_VAL,	SIO4_SET_XMT_ISOCHR_PROT,	0,	SIO4_USC_CMR,	0xFF00,	0	},
		{ SERVICE_END_LIST }
	};

	static const struct
	{
		int	two;
		u32	two_val;
	} data[]	=
	{
		// two	two_val
		{ 0,	0x0000	},
		{ 1,	0x4000	},
		{ -1, 0 }
	};

	int					errs	= 0;
	int					i;
	XMT_ISOCHR_PROTOCOL	prot;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; data[i].two >= 0; i++)
	{
		memset(&prot, 0, sizeof(prot));
		prot.u8TwoStopBits	= data[i].two;
		list[0].arg			= (unsigned long) &prot;
		list[0].value		= 0x0200 | data[i].two_val;
		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int set_xmt_isochr_prot_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_SET_XMT_ISOCHR_PROT");

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


