// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/set_rcv_hdlc_prot.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd						arg	reg				mask	value
		{ SERVICE_BY_VAL,	SIO4_SET_RCV_HDLC_PROT,	0,	SIO4_USC_CMR,	0xFF,	0	},
		{ SERVICE_END_LIST }
	};

	static const struct
	{
		int	mode;
		u32	mode_val;
		int	bit;
		u32	bit_val;
		int	log;
		u32	log_val;
	} data[]	=
	{
		// mode					mode_val	bit	bit_val		log	log_val
		{ DISABLED,				0x00,		0,	0x00,		0,	0x00	},
		{ ONE_BYTE_NO_CTRL,		0x10,		1,	0x40,		1,	0x80	},
		{ ONE_BYTE_PLUS_CTRL,	0x20,		0,	0x00,		0,	0x00	},
		{ EXT_PLUS_CTRL,		0x30,		1,	0x40,		1,	0x80	},
		{ -1, 0, 0, 0, 0, 0 }
	};

	int					errs	= 0;
	int					i;
	int					j;
	int					k;
	RCV_HDLC_PROTOCOL	prot;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; data[i].mode >= 0; i++)
	{
		for (j = 0; data[j].mode >= 0; j++)
		{
			for (k = 0; data[k].mode >= 0; k++)
			{
				memset(&prot, 0, sizeof(prot));
				prot.eAddrSearchMode		= (ADDR_SEARCH_MODE) data[i].mode;
				prot.u816BitControlEnable	= data[j].bit;
				prot.u8LogicalControlEnable	= data[k].log;
				list[0].arg					= (unsigned long) &prot;
				list[0].value				= 0x06
											| data[i].mode_val
											| data[j].bit_val
											| data[k].log_val;
				errs	+= service_ioctl_set_reg_list(fd, list);
				errs	+= service_ioctl_set_reg_list(fd, list);
			}
		}
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int set_rcv_hdlc_prot_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_SET_RCV_HDLC_PROT");

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


