// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/set_brg1_mode.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	service_data_t	list[]	=
	{
		// service			cmd					arg					reg				mask	value
		{ SERVICE_BY_VAL,	SIO4_SET_BRG1_MODE, BRG_CONTINUOUS,		SIO4_USC_HCR,	0x20,	0x00	},
		{ SERVICE_BY_VAL,	SIO4_SET_BRG1_MODE, BRG_SINGLE_CYCLE,	SIO4_USC_HCR,	0x20,	0x20	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int set_brg1_mode_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_SET_BRG1_MODE");

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


