// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rx_io_mode_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	const service_data_t	list[]	=
	{
		// service			cmd						arg					reg	mask	value
		{ SERVICE_BY_PTR,	SIO4_RX_IO_MODE_CONFIG,	SIO4_IO_MODE_PIO,	0,	0,		0	},
		{ SERVICE_BY_PTR,	SIO4_RX_IO_MODE_CONFIG,	SIO4_IO_MODE_DMA,	0,	0,		0	},
		{ SERVICE_BY_PTR,	SIO4_RX_IO_MODE_CONFIG,	SIO4_IO_MODE_DMDMA,	0,	0,		0	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int rx_io_mode_config_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_RX_IO_MODE_CONFIG");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


