// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rx_io_abort.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_abort;
static	int	_started;



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _rx_thread(void* arg)
{
	char	buf[512];
	int		fd		= (int) (long) arg;

	_started	= 1;

	for (;;)
	{
		read(fd, buf, sizeof(buf));

		if (_abort)
			break;
	}

	_abort	= 0;
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list_1[]	=
	{
		// service			cmd						arg					reg	mask	value
		{ SERVICE_BY_PTR,	SIO4_RX_IO_MODE_CONFIG,	SIO4_IO_MODE_DMA,	0,	0,		0	},
		{ SERVICE_BY_VAL,	SIO4_SET_READ_TIMEOUT,	1,					0,	0,		0	},
		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		// service			cmd	arg		reg	mask	value
		{ SERVICE_SLEEP_MS,	0,	100,	0,	0,		0	},
		{ SERVICE_END_LIST }
	};

	s32			aborted	= 0;
	int			errs	= 0;
	int			sleeps;
	int			status;
	os_thread_t	thread;

	_started	= 0;
	errs		+= sio4_reset_channel(fd, 0);
	errs		+= service_ioctl_set_reg_list(fd, list_1);
	errs		+= os_thread_create(&thread, "rx abort", _rx_thread, (void*) (long) fd);

	// Wait for the thread to start.

	for (sleeps = 0; errs == 0;)
	{
		if (_started)
			break;

		if (sleeps >= 1000)
		{
			errs++;
			printf(	"FAIL <---  (%d. Thread taking to long to start.)\n",
					__LINE__);
			break;
		}

		os_sleep_ms(10);
		sleeps++;
	}

	// Wait for the abort to take place.

	for (; errs == 0;)
	{
		status	= ioctl(fd, SIO4_RX_IO_ABORT, &aborted);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. SIO4_RX_IO_ABORT: errno %d)\n",
					__LINE__,
					errno);
			break;
		}
		else if (aborted)
		{
			break;
		}
		else
		{
			errs	+= service_ioctl_set_reg_list(fd, list_2);
		}
	}

	// Wait for the thread to complete.
	_abort	= 1;

	for (; errs == 0;)
	{
		if (_abort == 0)
			break;
		else
			os_sleep_ms(10);
	}

	errs	+= os_thread_destroy(&thread);
	return(errs);
}



//*****************************************************************************
int rx_io_abort_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_RX_IO_ABORT");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


