// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rx_fifo_full_cfg_glb.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service			cmd							arg								reg				mask	value
		{ SERVICE_BY_PTR,	SIO4_RX_FIFO_FULL_CFG_GLB,	SIO4_RX_FIFO_FULL_CFG_GLB_OVER,	SIO4_GSC_BCR,	0x100,	0x000	},
		{ SERVICE_BY_PTR,	SIO4_RX_FIFO_FULL_CFG_GLB,	SIO4_RX_FIFO_FULL_CFG_GLB_HALT,	SIO4_GSC_BCR,	0x100,	0x100	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list);
	errs	+= service_ioctl_set_reg_list(fd, list);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int rx_fifo_full_cfg_glb_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_RX_FIFO_FULL_CFG_GLB");

	if (data->rx_ffcg)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


