// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/rx_fifo_ae_config.c $
// $Rev: 43033 $
// $Date: 2018-06-22 17:41:58 -0500 (Fri, 22 Jun 2018) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _subtest(int fd, u32 value)
{
	int	errs	= 0;
	u32	rar;
	int	status;

	status	= ioctl(fd, SIO4_RX_FIFO_AE_CONFIG, (void*) &value);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_RX_FIFO_AE_CONFIG, "
				"value 0x%04lX, errno %d)\n",
				__LINE__,
				(long) value,
				errno);
	}

	errs	+= reg_read(fd, -1, 0, SIO4_GSC_RAR, &rar);

	if ((errs == 0) && ((rar & 0xFFFF) != value))
	{
		printf(	"FAIL <---  (%d. expected 0x%04lX, got 0x%04lX)\n",
				__LINE__,
				(long) value,
				(long) (rar & 0xFFFF));
	}

	return(errs);
}



//*****************************************************************************
static int _service_test(int fd)
{
	int	errs	= 0;
	int	i;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; i <= 16; i++)
	{
		errs	+= _subtest(fd, 0xFFFF & (0x1 << i));
		errs	+= _subtest(fd, 0xFFFF & ((0x1 << i) ^ 0xFFFF));
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int rx_fifo_ae_config_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_RX_FIFO_AE_CONFIG");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


