// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/reset_fifo.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service			cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,	0,	0,	SIO4_GSC_CSR,	0x3,	0x0 },
		{ SERVICE_END_LIST }
	};

	static const TX_RX	data[]	=
	{
		TX_FIFO,
		RX_FIFO,
		TX_AND_RX_FIFO,
		(TX_RX) -1
	};

	int		errs	= 0;
	int		i;
	int		status;

	errs	+= sio4_reset_channel(fd, 0);

	for (i = 0; data[i] != -1; i++)
	{
		status	= ioctl(fd, SIO4_RESET_FIFO, data[i]);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. SIO4_RESET_FIFO: arg %ld, errno %d)\n",
					__LINE__,
					(long) data[i],
					errno);
			break;
		}

		errs	+= service_ioctl_set_reg_list(fd, list);
		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	return(errs);
}



//*****************************************************************************
static int _tx_fifo_reset(int fd, TX_RX which)
{
	static const service_data_t	list_1[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF00,	0xC00	},
		{ SERVICE_REG_WRITE,	0,	30, SIO4_GSC_FDR,	0x0,	0x0		},
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF00,	0xF00	},
		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF00,	0xC00	},
		{ SERVICE_END_LIST }
	};

	int		errs	= 0;
	int		status;

	errs	+= sio4_reset_channel(fd, 0);
	errs	+= service_ioctl_set_reg_list(fd, list_1);
	status	= ioctl(fd, SIO4_RESET_FIFO, which);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_RESET_FIFO: arg %ld, errno %d)\n",
				__LINE__,
				(long) which,
				errno);
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);
	return(errs);
}



//*****************************************************************************
static int _rx_setup_legacy(int fd)
{
	sio4_async_t	async;
	int				errs	= 0;
	sio4_mp_t		mp;
	int				status;

	status	= ioctl(fd, SIO4_MP_INFO, (void*) &mp);

	if (status)
	{
		errs++;
		printf("FAIL <---  (%d. SIO4_MP_INFO: errno %d)\n", __LINE__, errno);
	}

	sio4_async_t_init(&async);
	async.cable.dcedte.enable	= 0;
	async.loopback.enable		= 1;

	if (mp.prot_got > 0)
		async.cable.xceiver	= mp.prot_got;

	errs	+= sio4_async_config(fd, &async, 0, 0);
	return(errs);
}



//*****************************************************************************
static int _rx_setup_sync(int fd)
{
	int				errs	= 0;
	int				ret;
	sio4_sync_rx_t	rx;
	sio4_sync_t		sync;
	sio4_sync_tx_t	tx;

	errs	+= osc_program(fd, 1000000, NULL, 0);

	tx.enable			= 1;
	tx.auto_dis			= 0;
	tx.lsbf				= 0;
	tx.word_size		= 8;
	tx.gap_size			= 0;
	tx.clock.clock		= 1;
	tx.clock.ext		= 0;
	tx.clock.high		= 1;
	tx.clock.idle		= 0;
	tx.env.env			= 1;
	tx.env.high			= 1;
	tx.data.data		= 1;
	tx.data.high		= 1;
	tx.aux_clock.enable	= 0;
	tx.aux_clock.clock	= 0;
	tx.aux_clock.high	= 0;
	tx.spare.enable		= 0;
	tx.spare.high		= 0;
	ret					= sio4_sync_tx_set(fd, &tx);

	if (ret)
	{
		errs++;
		printf("FAIL <---  (sio4_sync_tx_set() returned %d)\n", ret);
	}

	rx.enable			= 1;
	rx.lsbf				= 0;
	rx.reset			= 0;
	rx.word_size		= 8;
	rx.clock.high		= 1;
	rx.env.enable		= 1;
	rx.env.high			= 1;
	rx.data.high		= 1;
	ret					= sio4_sync_rx_set(fd, &rx);

	if (ret)
	{
		errs++;
		printf("FAIL <---  (sio4_sync_rx_set() returned %d)\n", ret);
	}

	sync.dce_enable		= 1;
	sync.dte_enable		= 0;
	sync.lb.enable		= 1;
	sync.lb.internal	= 1;
	ret					= sio4_sync_set(fd, &sync);

	if (ret)
	{
		errs++;
		printf("FAIL <---  (sio4_sync_set() returned %d)\n", ret);
	}

	return(errs);
}



//*****************************************************************************
static int _rx_setup_zilog(int fd)
{
	sio4_async_t	async;
	int				errs	= 0;
	sio4_mp_t		mp;
	int				status;

	status	= ioctl(fd, SIO4_MP_INFO, (void*) &mp);

	if (status)
	{
		errs++;
		printf("FAIL <---  (%d. SIO4_MP_INFO: errno %d)\n", __LINE__, errno);
	}

	sio4_async_t_init(&async);
	async.cable.dcedte.enable	= 1;
	async.loopback.enable		= 1;

	if (mp.prot_got > 0)
		async.cable.xceiver	= mp.prot_got;

	errs	+= sio4_async_config(fd, &async, 0, 0);
	return(errs);
}



//*****************************************************************************
static int _rx_fifo_reset(int fd, const data_t* data, TX_RX which)
{
	static const service_data_t	list_1[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF000,	0xC000	},
		{ SERVICE_REG_WRITE,	0,	30,	SIO4_GSC_FDR,	0x0,	0x0		},
		{ SERVICE_SLEEP_MS,		0,	90,	0,				0,		0		},
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF000,	0xF000	},
		{ SERVICE_END_LIST }
	};

	static const service_data_t	list_2[]	=
	{
		// service				cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,		0,	0,	SIO4_GSC_CSR,	0xF00,	0xC00	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	status;

	errs	+= sio4_reset_channel(fd, 0);

	if (data->fw_type == SIO4_FW_TYPE_CONFIG_SYNC)
		errs	+= _rx_setup_sync(fd);
	else if (data->legacy)
		errs	+= _rx_setup_legacy(fd);
	else
		errs	+= _rx_setup_zilog(fd);

	errs	+= service_ioctl_set_reg_list(fd, list_1);
	status	= ioctl(fd, SIO4_RESET_FIFO, which);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_RESET_FIFO: arg %ld, errno %d)\n",
				__LINE__,
				(long) which,
				errno);
	}

	errs	+= service_ioctl_set_reg_list(fd, list_2);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data)
{
	int	errs	= 0;

	errs	+= _tx_fifo_reset(fd, TX_FIFO);
	errs	+= _tx_fifo_reset(fd, TX_AND_RX_FIFO);

	errs	+= _rx_fifo_reset(fd, data, RX_FIFO);
	return(errs);
}



//*****************************************************************************
int reset_fifo_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_RESET_FIFO");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd, data);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}



