// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/reset_device.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service			cmd					arg	reg				mask		value
		{ SERVICE_BY_VAL,	SIO4_RESET_DEVICE,	0,	SIO4_GSC_BCR,	0x80000000,	0x00000000	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const service_data_t	list[]	=
	{
		// service				cmd					arg	reg				mask		value
		{ SERVICE_REG_WRITE,	0,					1,	SIO4_GSC_TAR,	0,			0xAAAAAAAA	},
		{ SERVICE_BY_VAL,		SIO4_RESET_DEVICE,	0,	SIO4_GSC_TAR,	0xFFFFFFFF,	0x00070007	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;

	errs	+= service_ioctl_set_reg_list(fd, list);

	errs	+= service_ioctl_set_reg_list(fd, list);

	return(errs);
}



//*****************************************************************************
int reset_device_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_RESET_DEVICE");

	if (data->brd_reset)
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


