// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/read_register_raw.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	char			buf[32];
	int				errs	= 0;
	int				i;
	REGISTER_PARAMS	parm;
	int				status;

	for (i = 0; i <= 64; i++)
	{
		sprintf(buf, "#%d", i);
		parm.u32RegisterNumber	= i;
		parm.u32Value			= 0xDEADBEEF;
		status	= ioctl(fd, SIO4_READ_REGISTER_RAW, (void*) &parm);

		if (i <= 63)
		{
			if (status != 0)
			{
				errs	= 1;
				printf(	"FAIL <---  (SIO4_READ_REGISTER_RAW (%d. %s).)\n",
						i,
						buf);
				break;
			}
		}
		else if (status == 0)
		{
			errs	= 1;
			printf(	"FAIL <---  (Error expected but did not occur (%d. %s).)\n",
					i,
					buf);
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int read_register_raw_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_READ_REGISTER_RAW");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


