// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/read_register.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const struct
	{
		u32	reg;
		u32	value;
	} list[]	=
	{
		// reg				value
		{ SIO4_GSC_FRR,		0		},
		{ SIO4_GSC_BCR,		0		},
		{ SIO4_GSC_BSR,		0		},
		{ SIO4_GSC_CCR,		0		},
		{ SIO4_GSC_TSR,		0		},
		{ SIO4_GSC_TAR,		0		},
		{ SIO4_GSC_RAR,		0		},
		{ SIO4_GSC_FDR,		0		},
		{ SIO4_GSC_CSR,		0		},
		{ SIO4_GSC_SBR,		0		},
		{ SIO4_GSC_ICR,		0		},
		{ SIO4_GSC_ISR,		0		},
		{ SIO4_GSC_IELR,	0		},
		{ SIO4_GSC_IHLR,	0		},
		{ SIO4_GSC_PSRCR,	0		},
		{ SIO4_GSC_PSTSR,	0		},
		{ SIO4_GSC_GPIOSR,	0		},
		{ SIO4_GSC_IOCR,	0		},
		{ SIO4_GSC_FCR,		0		},
		{ SIO4_GSC_FSR,		0		},
		{ SIO4_GSC_FTR,		0		},
		{ SIO4_GSC_FR,		0		},
		{ SIO4_GSC_TCR,		0		},
		{ SIO4_GSC_RCR,		0		},
		{ SIO4_GSC_PORAR,	0		},
		{ SIO4_GSC_PORDR,	0		},
		{ SIO4_GSC_POCSR,	0		},
		{ SIO4_GSC_PORD2R,	0		},
		{ SIO4_GSC_PCR,		0		},
		{ SIO4_GSC_PCDR,	0		},

		{ SIO4_PCI_VID,		0x10B5	},
		{ SIO4_PCI_DID,		0		},
		{ SIO4_PCI_SVID,	0x10B5	},
		{ SIO4_PCI_SID,		0		},
	};

	int				errs	= 0;
	int				i;
	int				j;
	REGISTER_PARAMS	parm;

	for (i = 0; i < SIZEOF_ARRAY(list); i++)
	{
		parm.u32RegisterNumber	= list[i].reg;
		parm.u32Value			= 0xDEADBEEF;
		j	= ioctl(fd, SIO4_READ_REGISTER, (void*) &parm);

		if (j)
		{
			errs	= 1;
			printf(	"FAIL <---  (%d. i %d, ioctl() failure, errno %d)\n",
					__LINE__,
					i,
					errno);
			break;
		}

		if (parm.u32Value == 0xDEADBEEF)
		{
			errs	= 1;
			printf("FAIL <---  (%d. i %d, value not changed)\n", __LINE__, i);
			break;
		}

		if ((list[i].value) && (parm.u32Value != list[i].value))
		{
			errs	= 1;
			printf(	"FAIL <---  (%d. i %d, got 0x%lX, expected 0x%lX)\n",
					__LINE__,
					i,
					(long) parm.u32Value,
					(long) list[i].value);
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int read_register_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_READ_REGISTER");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


