// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/read_int_status.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	int						errs	= 0;
	SIO4_INTERRUPT_STATUS	irq;
	int						status;

	errs	+= sio4_reset_channel(fd, 0);
	status	= ioctl(fd, SIO4_READ_INT_STATUS, (void*) &irq);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_READ_INT_STATUS, errno %d)\n",
				__LINE__,
				errno);
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int read_int_status_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_READ_INT_STATUS");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}



