// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/osc_reference.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _reference_set(int fd, u32 want, u32* got, int line)
{
	int			errs	= 0;
	sio4_osc_t	osc;
	int			ret;

	memset(&osc, 0, sizeof(osc));
	osc.freq_ref	= want;
	ret				= sio4_ioctl(fd, SIO4_OSC_REFERENCE, &osc);

	if (ret < 0)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_OSC_REFERENCE)\n",
				line);
	}
	else if (osc.freq_ref != want)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_OSC_REFERENCE, expected %ld, got %ld)\n",
				line,
				(long) want,
				(long) osc.freq_ref);
	}

	if (got)
		got[0]	= osc.freq_ref;

	return(errs);
}



//*****************************************************************************
static int _osc_reference_test(int fd, const data_t* data, s32 ref)
{
	u32		delta		= 0;
	int		errs		= 0;
	s32		freq_ref;
	u32		got			= 0;
	s32		max			= 0;
	s32		min			= 0;

	errs	+= sio4_reset_channel(fd, 0);

	switch (data->osc_chip)
	{
		default:

			errs++;
			printf("FAIL <---  (%d. internal error)\n", __LINE__);
			break;

		case SIO4_OSC_CHIP_FIXED:

			min		= 1000000L;
			max		= 20000000L;
			delta	= 1000000L;
			break;

		case SIO4_OSC_CHIP_CY22393:
		case SIO4_OSC_CHIP_CY22393_2:

			min		= ref;
			max		= ref;
			delta	= 1000000L;
			break;
	}

	for (freq_ref = min; (errs == 0) && (freq_ref <= max); freq_ref += delta)
	{
		errs	+= _reference_set(fd, freq_ref, &got, __LINE__);

		switch (data->osc_chip)
		{
			default:

				errs++;
				printf("FAIL <---  (%d. internal error)\n", __LINE__);
				break;

			case SIO4_OSC_CHIP_FIXED:

				break;

			case SIO4_OSC_CHIP_CY22393:
			case SIO4_OSC_CHIP_CY22393_2:

				if ((errs) && (freq_ref != ref))
				{
					errs	= 0;
					continue;
				}

				break;
		}

		if (errs)
			break;

		switch (data->osc_chip)
		{
			default:

				errs++;
				printf("FAIL <---  (%d. internal error)\n", __LINE__);
				break;

			case SIO4_OSC_CHIP_FIXED:

				if (got == freq_ref)
					break;

				printf(	"FAIL <---  (%d. expected %ld, got %ld)\n",
						__LINE__,
						(long) freq_ref,
						(long) got);
				errs++;
				break;

			case SIO4_OSC_CHIP_CY22393:
			case SIO4_OSC_CHIP_CY22393_2:

				if (got == freq_ref)
					break;

				printf(	"FAIL <---  (%d. expected %ld, got %ld)\n",
						__LINE__,
						(long) ref,
						(long) got);
				errs++;
				break;
		}
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data, s32 ref)
{
	int	errs;

	errs	= _osc_reference_test(fd, data, ref);
	return(errs);
}



//*****************************************************************************
int osc_reference_tests(int fd, const data_t* data)
{
	int	errs	= 0;
	s32	ref		= SIO4_OSC_FREQ_REF_DEFAULT;

	gsc_label("SIO4_OSC_REFERENCE");

	if (data->osc_measure)
		errs	+= sio4_osc_reference(fd, &ref, 0);

	if (errs == 0)
	{
		switch (data->osc_chip)
		{
			default:

				printf(	"SKIPPED  (Unrecognized oscillator option: %ld)\n",
						(long) data->osc_chip);
				break;

			case SIO4_OSC_CHIP_UNKNOWN:

				errs++;
				printf("FAIL <---  (Oscillator chip not recognized.)\n");
				break;

			case SIO4_OSC_CHIP_IDC2053B:
			case SIO4_OSC_CHIP_IDC2053B_4:

				printf("SKIPPED  (Oscillator chip not supported by test.)\n");
				break;

			case SIO4_OSC_CHIP_FIXED:
			case SIO4_OSC_CHIP_CY22393:
			case SIO4_OSC_CHIP_CY22393_2:

				errs	+= _service_test(fd);
				errs	+= _function_test(fd, data, ref);

				if (errs == 0)
					printf("PASS\n");

				break;
		}
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


