// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/mp_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd, const data_t* data)
{
	static const struct
	{
		sio4_mp_prot_t	prot;
		s32				value;
	} prots[]	=
	{
		// prot							value
		{ SIO4_MP_PROT_RS_422_485,		0x00000000	},
		{ SIO4_MP_PROT_RS_423,			0x01000000	},
		{ SIO4_MP_PROT_RS_232,			0x02000000	},
		{ SIO4_MP_PROT_RS_530_M1,		0x04000000	},
		{ SIO4_MP_PROT_RS_530_M2,		0x05000000	},
		{ SIO4_MP_PROT_V35_M1,			0x06000000	},
		{ SIO4_MP_PROT_V35_M2,			0x07000000	},
		{ SIO4_MP_PROT_RS_422_423_MM1,	0x08000000	},
		{ SIO4_MP_PROT_RS_422_423_MM2,	0x09000000	},
		{ (sio4_mp_prot_t) 0, -1 }
	};

	service_data_t	list[]	=
	{
		// service			cmd	arg	reg				mask		value
		{ SERVICE_REG_TEST,	0,	0,	SIO4_GSC_PSRCR,	0xF000000,	0	},
		{ SERVICE_END_LIST }
	};

	int			errs	= 0;
	int			i;
	int			l;
	sio4_mp_t	mp;
	int			status;

	errs	+= sio4_reset_channel(fd, 0);

	for (l = 1; l <= 2; l++)
	{
		for (i = 0; (errs == 0) && (prots[i].value >= 0); i++)
		{
			if ((data->mp_bitmap & prots[i].prot) == 0)
				continue;

			memset(&mp, 0, sizeof(mp));
			mp.prot_want	= prots[i].prot;
			status			= ioctl(fd, SIO4_MP_CONFIG, (void*) &mp);

			if (status)
			{
				errs++;
				printf(	"FAIL <---  (%d. ioctl: i %d, errno %d)\n",
						__LINE__,
						i,
						errno);
				break;
			}

			if (mp.chip != data->mp_chip)
			{
				errs++;
				printf(	"FAIL <---  (%d. chip: i %d"
						", got %ld, expected %ld)\n",
						__LINE__,
						i,
						(long) mp.chip,
						(long) data->mp_chip);
				break;
			}

			list[0].value	= prots[i].value;
			errs			+= service_ioctl_set_reg_list(fd, list);
		}
	}

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int mp_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_MP_CONFIG");

	if ((data->mp) && (data->mp_program))
	{
		switch (data->mp_chip)
		{
			default:

				printf(	"SKIPPED  (Unrecognized Xcvr option: %ld)\n",
						(long) data->mp_chip);
				break;

			case SIO4_MP_CHIP_FIXED:

				printf("SKIPPED  (Not supported.)\n");
				break;

			case SIO4_MP_CHIP_UNKNOWN:

				errs++;
				printf("FAIL <---  (MP chip not supported by test.)\n");
				break;

			case SIO4_MP_CHIP_SP508:

				errs	+= _service_test(fd, data);
				errs	+= _function_test(fd);

				if (errs == 0)
					printf("PASS\n");

				break;
		}
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


