// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/mod_register.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _walk_1(int fd, const char* name, u32 reg, u32 mask)
{
	u32					bit;
	int					errs	= 0;
	int					i;
	u32					original;
	REGISTER_MOD_PARAMS	parm;
	int					status;
	u32					temp;
	u32					value;

	errs	+= reg_read(fd, -1, 0, reg, &original);
	value	= original & ~mask;
	errs	+= reg_write(fd, reg, value);

	for (i = 0; i <= 31; i++)
	{
		bit	= 0x1 << i;

		if ((bit & mask) == 0)
			continue;

		value					= (original & ~mask) | bit;
		parm.u32RegisterNumber	= reg;
		parm.u32Value			= bit;
		parm.u32Mask			= mask;
		status					= ioctl(fd, SIO4_MOD_REGISTER, (void*) &parm);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. W1: %s: i %d, SIO4_MOD_REGISTER, errno %d)\n",
					__LINE__,
					name,
					i,
					errno);
			break;
		}

		errs	+= reg_read(fd, -1, 0, reg, &temp);

		if (temp != value)
		{
			errs++;
			printf(	"FAIL <---  (%d. W1: %s: expected 0x%08lX, got 0x%08lX)\n",
					__LINE__,
					name,
					(long) value,
					(long) temp);
		}
	}

	errs	+= reg_write(fd, reg, original);
	return(errs);
}



//*****************************************************************************
static int _walk_0(int fd, const char* name, u32 reg, u32 mask)
{
	u32					bit;
	int					errs	= 0;
	int					i;
	u32					original;
	REGISTER_MOD_PARAMS	parm;
	int					status;
	u32					temp;
	u32					value;

	errs	+= reg_read(fd, -1, 0, reg, &original);
	value	= (original & ~mask) | (0xFFFFFFFF & mask);
	errs	+= reg_write(fd, reg, value);

	for (i = 0; i <= 31; i++)
	{
		bit	= 0x1 << i;

		if ((bit & mask) == 0)
			continue;

		value					= (original & ~mask) | (bit ^ mask);
		parm.u32RegisterNumber	= reg;
		parm.u32Value			= (bit ^ mask);
		parm.u32Mask			= mask;
		status					= ioctl(fd, SIO4_MOD_REGISTER, (void*) &parm);

		if (status)
		{
			errs++;
			printf(	"FAIL <---  (%d. W0: %s: i %d, SIO4_MOD_REGISTER, errno %d)\n",
					__LINE__,
					name,
					i,
					errno);
			break;
		}

		errs	+= reg_read(fd, -1, 0, reg, &temp);

		if (temp != value)
		{
			errs++;
			printf(	"FAIL <---  (%d. W0: %s: expected 0x%08lX, got 0x%08lX)\n",
					__LINE__,
					name,
					(long) value,
					(long) temp);
		}
	}

	errs	+= reg_write(fd, reg, original);
	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	static const struct
	{
		const char*	name;
		u32			reg;
		u32			mask;
	} list[]	=
	{
		// name		reg				mask
		{ "TAR",	SIO4_GSC_TAR,	0xFFFFFFFF	},
		{ "RAR",	SIO4_GSC_RAR,	0xFFFFFFFF	},
	};

	int	errs	= 0;
	int	i;

	for (i = 0; (errs == 0) && (i < (int) SIZEOF_ARRAY(list)); i++)
	{
		errs	+= _walk_1(fd, list[i].name, list[i].reg, list[i].mask);
		errs	+= _walk_0(fd, list[i].name, list[i].reg, list[i].mask);
	}

	return(errs);
}



//*****************************************************************************
int mod_register_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_MOD_REGISTER");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


