// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/main.h $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// macros *********************************************************************

#define	D19									(0x1L << 19)



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	detail;
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for the device to access.

	// Device Settings

} args_t;



typedef struct
{
	s32	brd_reset;		// feature test: Board Reset
	s32	channel;		// feature test: Channel Index
	s32	detail;			// from command line
	s32	feature_qty;	// feature test
	s32	fw_type;		// current firmware type
	s32	irq_32;			// feature test
	s32	jumper_qty;		// feature test
	s32	legacy;			// feature test: Legacy Cable Interface
	s32	mp;				// feature test: Multi-Protocol (Transceivers)
	s32	mp_bitmap;		// feature test
	s32	mp_chip;		// feature test
	s32	mp_program;		// feature test
	s32	osc_chip;		// feature test
	s32	osc_measure;	// feature test
	s32	osc_program;	// feature test
	s32	reg_ccr;		// feature test
	s32	reg_fcr;		// feature test
	s32	reg_fsr;		// feature test
	s32	reg_psrcr;		// feature test
	s32	rx_ffcc;		// feature test: Rx FIFO Full Config (Channel)
	s32	rx_ffcg;		// feature test: Rx FIFO Full Config Global
} data_t;

typedef enum
{
	SERVICE_END_LIST,	// Ends list of service_data_t structures.
	SERVICE_BY_PTR,
	SERVICE_BY_VAL,
	SERVICE_REG_MOD,
	SERVICE_REG_READ,
	SERVICE_REG_SHOW,
	SERVICE_REG_TEST,
	SERVICE_REG_WRITE,
	SERVICE_SLEEP,
	SERVICE_SLEEP_MS
} service_t;

typedef struct
{
	service_t		service;
	int				cmd;	// IOCTL code
	unsigned long	arg;	// The IOCTL data argument.
	u32				reg;	// The register to access. Use -1 to ignore.
	u32				mask;	// The register bits of interest.
	u32				value;	// The value expected for the bits of interest.
} service_data_t;



// prototypes *****************************************************************

int	board_jumpers_tests					(int fd, const data_t* data);	// SIO4_BOARD_JUMPERS

int	cable_config_tests					(int fd, const data_t* data);	// SIO4_CABLE_CONFIG
int	clear_dpll_status_tests				(int fd, const data_t* data);	// SIO4_CLEAR_DPLL_STATUS
int	cts_cable_config_tests				(int fd, const data_t* data);	// SIO4_CTS_CABLE_CONFIG

int	dcd_cable_config_tests				(int fd, const data_t* data);	// SIO4_DCD_CABLE_CONFIG

int	enable_brg0_tests					(int fd, const data_t* data);	// SIO4_ENABLE_BRG0
int	enable_brg1_tests					(int fd, const data_t* data);	// SIO4_ENABLE_BRG1

int	feature_test_tests					(int fd, const data_t* data);	// SIO4_FEATURE_TEST

int	get_driver_info_tests				(int fd);						// SIO4_GET_DRIVER_INFO

int	init_board_tests					(int fd, const data_t* data);	// SIO4_INIT_BOARD
int	init_channel_tests					(int fd, const data_t* data);	// SIO4_INIT_CHANNEL
int	int_notify_tests					(int fd, const data_t* data);	// SIO4_INT_NOTIFY

int	mod_register_tests					(int fd);						// SIO4_MOD_REGISTER
int	mp_config_tests						(int fd, const data_t* data);	// SIO4_MP_CONFIG
int	mp_info_tests						(int fd, const data_t* data);	// SIO4_MP_INFO
int	mp_init_tests						(int fd, const data_t* data);	// SIO4_MP_INIT
int	mp_reset_tests						(int fd, const data_t* data);	// SIO4_MP_RESET
int	mp_test_tests						(int fd, const data_t* data);	// SIO4_MP_TEST

int	no_function_tests					(int fd);						// SIO4_NO_FUNCTION

int	osc_info_tests						(int fd, const data_t* data);	// SIO4_OSC_INFO
int	osc_init_tests						(int fd, const data_t* data);	// SIO4_OSC_INIT
int	osc_measure_tests					(int fd, const data_t* data);	// SIO4_OSC_MEASURE
int	osc_program_tests					(int fd, const data_t* data);	// SIO4_OSC_PROGRAM
int	osc_reference_tests					(int fd, const data_t* data);	// SIO4_OSC_REFERENCE
int	osc_reset_tests						(int fd, const data_t* data);	// SIO4_OSC_RESET
int	osc_test_tests						(int fd, const data_t* data);	// SIO4_OSC_TEST

int	perform_tests(const args_t* args);

int	read_int_status_tests				(int fd);						// SIO4_READ_INT_STATUS
int	read_register_raw_tests				(int fd);						// SIO4_READ_REGISTER_RAW
int	read_register_tests					(int fd);						// SIO4_READ_REGISTER
int	reset_channel_tests					(int fd);						// SIO4_RESET_CHANNEL
int	reset_device_tests					(int fd, const data_t* data);	// SIO4_RESET_DEVICE
int	reset_fifo_tests					(int fd, const data_t* data);	// SIO4_RESET_FIFO
int	reset_usc_tests						(int fd, const data_t* data);	// SIO4_RESET_USC
int	reset_zilog_chip_tests				(int fd, const data_t* data);	// SIO4_RESET_ZILOG_CHIP
int	rx_cable_config_tests				(int fd, const data_t* data);	// SIO4_RX_CABLE_CONFIG
int	rx_fifo_ae_config_tests				(int fd);						// SIO4_RX_FIFO_AE_CONFIG
int	rx_fifo_af_config_tests				(int fd);						// SIO4_RX_FIFO_AF_CONFIG
int	rx_fifo_count_tests					(int fd, const data_t* data);	// SIO4_RX_FIFO_COUNT
int	rx_fifo_full_cfg_chan_tests			(int fd, const data_t* data);	// SIO4_RX_FIFO_FULL_CFG_CHAN
int	rx_fifo_full_cfg_glb_tests			(int fd, const data_t* data);	// SIO4_RX_FIFO_FULL_CFG_GLB
int	rx_fifo_size_tests					(int fd, const data_t* data);	// SIO4_RX_FIFO_SIZE
int	rx_fifo_status_tests(int fd);				// SIO4_RX_FIFO_STATUS
int	rx_io_abort_tests					(int fd);						// SIO4_RX_IO_ABORT
int	rx_io_mode_config_tests				(int fd);						// SIO4_RX_IO_MODE_CONFIG
int	rxc_usc_config_tests				(int fd, const data_t* data);	// SIO4_RXC_USC_CONFIG

int	select_dpll_resync_tests			(int fd, const data_t* data);	// SIO4_SELECT_DPLL_RESYNC
int	send_channel_command_tests			(int fd, const data_t* data);	// SIO4_SEND_CHANNEL_COMMAND
int	set_brg0_mode_tests					(int fd, const data_t* data);	// SIO4_SET_BRG0_MODE
int	set_brg0_source_tests				(int fd, const data_t* data);	// SIO4_SET_BRG0_SOURCE
int	set_brg1_mode_tests					(int fd, const data_t* data);	// SIO4_SET_BRG1_MODE
int	set_brg1_source_tests				(int fd, const data_t* data);	// SIO4_SET_BRG1_SOURCE
int	set_ctr0_source_tests				(int fd, const data_t* data);	// SIO4_SET_CTR0_SOURCE
int	set_ctr1_source_tests				(int fd, const data_t* data);	// SIO4_SET_CTR1_SOURCE
int	set_dpll_divisor_tests				(int fd, const data_t* data);	// SIO4_SET_DPLL_DIVISOR
int	set_dpll_mode_tests					(int fd, const data_t* data);	// SIO4_SET_DPLL_MODE
int	set_dpll_source_tests				(int fd, const data_t* data);	// SIO4_SET_DPLL_SOURCE
int	set_rcv_async_prot_tests			(int fd, const data_t* data);	// SIO4_SET_RCV_ASYNC_PROT
int	set_rcv_hdlc_prot_tests				(int fd, const data_t* data);	// SIO4_SET_RCV_HDLC_PROT
int	set_rcv_isochr_prot_tests			(int fd, const data_t* data);	// SIO4_SET_RCV_ISOCHR_PROT
int	set_read_timeout_tests				(int fd);						// SIO4_SET_READ_TIMEOUT
int	set_rx_clock_source_tests			(int fd, const data_t* data);	// SIO4_SET_RX_CLOCK_SOURCE
int	set_sync_byte_tests					(int fd, const data_t* data);	// SIO4_SET_SYNC_BYTE
int	set_tx_clock_source_tests			(int fd, const data_t* data);	// SIO4_SET_TX_CLOCK_SOURCE
int	set_usc_dma_options_tests			(int fd, const data_t* data);	// SIO4_SET_USC_DMA_OPTIONS
int	set_write_timeout_tests				(int fd);						// SIO4_SET_WRITE_TIMEOUT
int	set_xmt_async_prot_tests			(int fd, const data_t* data);	// SIO4_SET_XMT_ASYNC_PROT
int	set_xmt_hdlc_prot_tests				(int fd, const data_t* data);	// SIO4_SET_XMT_HDLC_PROT
int	set_xmt_hdlc_sdlc_loop_prot_tests	(int fd, const data_t* data);	// SIO4_SET_XMT_HDLC_SDLC_LOOP_PROT
int	set_xmt_isochr_prot_tests			(int fd, const data_t* data);	// SIO4_SET_XMT_ISOCHR_PROT

int	service_ioctl_set_reg_list			(int fd, const service_data_t* list);

int	tx_cable_clock_config_tests			(int fd, const data_t* data);	// SIO4_TX_CABLE_CLOCK_CONFIG
int	tx_cable_config_tests				(int fd, const data_t* data);	// SIO4_TX_CABLE_CONFIG
int	tx_cable_data_config_tests			(int fd, const data_t* data);	// SIO4_TX_CABLE_DATA_CONFIG
int	tx_fifo_ae_config_tests				(int fd);						// SIO4_TX_FIFO_AE_CONFIG
int	tx_fifo_af_config_tests				(int fd);						// SIO4_TX_FIFO_AF_CONFIG
int	tx_fifo_count_tests					(int fd, const data_t* data);	// SIO4_TX_FIFO_COUNT
int	tx_fifo_size_tests					(int fd, const data_t* data);	// SIO4_TX_FIFO_SIZE
int	tx_fifo_status_tests				(int fd);						// SIO4_TX_FIFO_STATUS
int	tx_io_abort_tests					(int fd);						// SIO4_TX_IO_ABORT
int	tx_io_mode_config_tests				(int fd);						// SIO4_TX_IO_MODE_CONFIG
int	txc_usc_config_tests				(int fd, const data_t* data);	// SIO4_TXC_USC_CONFIG

int	write_register_tests				(int fd);						// SIO4_WRITE_REGISTER



#endif
