// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/get_driver_info.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd)
{
	int					errs	= 0;
	SIO4_DRIVER_INFO	info;
	int					status;

	memset(&info, 0, sizeof(info));
	status	= ioctl(fd, SIO4_GET_DRIVER_INFO, (void*) &info);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_GET_DRIVER_INFO, errno %d)\n",
				__LINE__,
				errno);
	}
	else if (strlen((char*) info.u8VersionNumber) >= sizeof(info.u8VersionNumber))
	{
		errs++;
		printf(	"FAIL <---  (%d. version number too long, got %ld, max %ld)\n",
				__LINE__,
				(long) strlen((char*) info.u8VersionNumber),
				(long) sizeof(info.u8VersionNumber));
	}
	else if (strlen((char*) info.u8Built) >= sizeof(info.u8Built))
	{
		errs++;
		printf(	"FAIL <---  (%d. date built too long, got %ld, max %ld)\n",
				__LINE__,
				(long) strlen((char*) info.u8Built),
				(long) sizeof(info.u8Built));
	}

	return(errs);
}



//*****************************************************************************
int get_driver_info_tests(int fd)
{
	int	errs	= 0;

	gsc_label("SIO4_GET_DRIVER_INFO");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


