// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/feature_test.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _service_test(int fd)
{
	return(0);
}



//*****************************************************************************
static int _function_test(int fd, const data_t* data)
{
	int	errs	= 0;
	int	i;
	int	status;
	s32	val;

	if (data->feature_qty != (SIO4_FEATURE_LAST_INDEX + 1))
	{
		errs	= 1;
		printf(	"FAIL <---  (FEATURE COUNT: expected %ld, got %ld)\n",
				(long) SIO4_FEATURE_LAST_INDEX + 1,
				(long) data->feature_qty);
	}
	else
	{
		for (i = 0; i < data->feature_qty; i++)
		{
			val		= i;
			status	= ioctl(fd, SIO4_FEATURE_TEST, (void*) &val);

			if (status)
			{
				errs++;
				printf("FAIL <---  (Option %d)\n", i);
				break;
			}
		}
	}

	return(errs);
}



//*****************************************************************************
int feature_test_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_FEATURE_TEST");

	errs	+= _service_test(fd);
	errs	+= _function_test(fd, data);

	if (errs == 0)
		printf("PASS\n");

	errs	= errs ? 1 : 0;
	return(errs);
}


