// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/sbtest/cts_cable_config.c $
// $Rev: 53081 $
// $Date: 2023-06-13 10:10:10 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _subtest(int fd, s32 arg, u32 mask1, u32 val1, u32 mask2, u32 val2)
{
	service_data_t	list[]	=
	{
		// service			cmd	arg	reg				mask	value
		{ SERVICE_REG_TEST,	0,	0,	SIO4_GSC_PSRCR,	mask1,	val1	},
		{ SERVICE_REG_TEST,	0,	0,	SIO4_USC_IOCR,	mask2,	val2	},
		{ SERVICE_END_LIST }
	};

	int	errs	= 0;
	int	status;

	status	= ioctl(fd, SIO4_CTS_CABLE_CONFIG, &arg);

	if (status)
	{
		errs++;
		printf(	"FAIL <---  (%d. SIO4_CTS_CABLE_CONFIG: arg %ld, errno %d)\n",
				__LINE__,
				(long) arg,
				errno);
	}
	else
	{
		errs	+= service_ioctl_set_reg_list(fd, list);

		errs	+= service_ioctl_set_reg_list(fd, list);
	}

	return(errs);
}



//*****************************************************************************
static int _service_test(int fd)
{
	int	errs	= 0;

	errs	+= sio4_reset_channel(fd, 0);

	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_DISABLE,	0x00000600, 0x00000000, 0x8000, 0x8000);
	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_CTS_IN,	0x00000600, 0x00000200, 0x8000, 0x0000);
	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_DRV_LOW,	0x00006600, 0x00004600, 0xC000, 0x8000);
	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_DRV_HI,	0x00006600, 0x00006600, 0xC000, 0xC000);
	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_DCD_IN,	0x00000600, 0x00000400, 0x8000, 0x0000);
	errs	+= _subtest(fd, SIO4_CTS_CABLE_CONFIG_RTS_OUT,	0x00006600, 0x00002600, 0x8000, 0x8000);

	return(errs);
}



//*****************************************************************************
static int _function_test(int fd)
{
	return(0);
}



//*****************************************************************************
int cts_cable_config_tests(int fd, const data_t* data)
{
	int	errs	= 0;

	gsc_label("SIO4_CTS_CABLE_CONFIG");

	if ((data->fw_type == SIO4_FW_TYPE_CONFIG_Z16C30) && (data->reg_psrcr))
	{
		errs	+= _service_test(fd);
		errs	+= _function_test(fd);

		if (errs == 0)
			printf("PASS\n");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	errs	= errs ? 1 : 0;
	return(errs);
}


