// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/regs/perform.c $
// $Rev: 53080 $
// $Date: 2023-06-13 10:08:16 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _dump_gsc(int fd)
{
	printf("GSC Registers:\n");
	sio4_reg_list(fd, 1, 0, 0, 0);
}



//*****************************************************************************
static void _dump_gsc_detail(int fd)
{
	printf("GSC Registers:\n");
	sio4_reg_list(fd, 1, 1, 0, 0);
}



//*****************************************************************************
static void _dump_pci(int fd)
{
	printf("PCI Registers:\n");
	reg_list_pci(fd);
}



//*****************************************************************************
static void _dump_plx(int fd)
{
	printf("PLX Registers:\n");
	reg_list_plx(fd);
}



//*****************************************************************************
static void _id_device(int fd)
{
	sio4_id_device(fd, -1, 1);
}



//*****************************************************************************
static void _id_driver(int fd)
{
	id_driver();
}



//*****************************************************************************
static void _id_host(int fd)
{
	id_host();
}



//*****************************************************************************
static void _dump_bar2(int fd)
{
	int				i;
	REGISTER_PARAMS	reg;
	int				ret;

	printf("\n");
	printf("BAR2 Dump  (partial)\n");
	printf("Offset  Value\n");
	printf("======  ==========\n");

	for (i = 0; i < 0x40; i += 4)
	{
		printf("0x%02lX  ", (long) i);
		reg.u32RegisterNumber	= i;
		reg.u32Value			= 0xDEADBEEF;
		ret						= ioctl(fd, SIO4_READ_REGISTER_RAW, &reg);
		printf("  0x%08lX", (long) reg.u32Value);

		if (ret)
		{
			printf("  FAIL <----  (ioctl() returned %d)\n", ret);
			break;
		}

		printf("\n");
	}
}



//*****************************************************************************
static void _dump_usc_regs(int fd, int detail)
{
	int	errs;
	s32	fw_type;

	printf("USC Registers:\n");
	errs	= sio4_fw_type_config(fd, -1, 0, SIO4_FW_TYPE_CONFIG_READ, &fw_type);

	if (errs)
	{
		printf("FAIL <---  (sio4_fw_type_config() error)\n");
	}
	else if (fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
	{
		sio4_reg_list(fd, 0, 0, 1, detail);
	}
	else
	{
		printf(	"USC REGISTER LIST: SKIPPED  (Not supported.)\n");
	}
}



//*****************************************************************************
static void _dump_usc(int fd)
{
	_dump_usc_regs(fd, 0);
}



//*****************************************************************************
static void _dump_usc_detail(int fd)
{
	_dump_usc_regs(fd, 1);
}



//*****************************************************************************
static void _dump_everything(int fd)
{
	_id_host(fd);
	printf("\n");

	_id_driver(fd);
	printf("\n");

	_id_device(fd);
	printf("\n");

	_dump_pci(fd);
	printf("\n");

	_dump_plx(fd);
	printf("\n");

	_dump_gsc_detail(fd);
	printf("\n");

	_dump_usc_detail(fd);
	printf("\n");

	_dump_bar2(fd);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Device Identification",			_id_device			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ "GSC Register Dump",				_dump_gsc			},
		{ "GSC Register Detail Dump",		_dump_gsc_detail	},
		{ "USC Register Dump",				_dump_usc			},
		{ "USC Register Detail Dump",		_dump_usc_detail	},
		{ "BAR2 Dump",						_dump_bar2			},
		{ "Edit GSC Register By Name",		reg_mod_by_name		},
		{ "Edit GSC Register By Offset",	reg_mod_by_offset	},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(args->fd, &menu);
	return(0);
}


