// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/regs/main.h $
// $Rev: 53080 $
// $Date: 2023-06-13 10:08:16 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	index;			// device index
	int	qty;			// Number of devices detected.

	int	fd;				// File descriptor for device to access.

	// Device Settings

} args_t;

typedef struct
{
	const char*	name;				// NULL terminates list.
	void		(*func)(int fd);	// NULL terminates list.
} menu_item_t;

typedef struct
{
	const char*			title;
	const menu_item_t*	list;
} menu_t;



// prototypes *****************************************************************

void	menu_call(int fd, const menu_t* menu);
int		menu_select(const menu_t* menu);

int		perform_tests(const args_t* args);

void	reg_mod_by_name(int fd);
void	reg_mod_by_offset(int fd);



#endif
