// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/tx_fifo_full.c $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	int	errs	= 0;
	s32	index;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Reset the Tx FIFO.
	errs	+= fifo_reset(fd, TX_FIFO, 1);

	// Setup asynchronous interrupt notification.
	errs	+= notify_enable(fd, SIO4_INT_NOTIFY_TX_FIFO_F, &_qty);

	// Disable the transmitter.
	errs	+= reg_mod(fd, SIO4_GSC_CSR, 0, 0x02000000);

	// Enable the interrupt.
	errs	+= sio4_feature_test(fd, SIO4_FEATURE_INDEX_CHANNEL, &index, 0);
	errs	+= reg_write(fd, SIO4_GSC_ICR, 0x20000 << (4 * index));
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	long	count	= 0;
	u32		csr;
	int		errs	= 0;

	// Manually force fill the Tx FIFO.

	for (;;)
	{
		errs	= reg_write(fd, SIO4_GSC_FDR, 0xAA);

		if (errs)
			break;

		errs	= reg_read(fd, -1, 0, SIO4_GSC_CSR, &csr);

		if (errs)
			break;

		if ((csr & 0x800) == 0)
			break;

		count++;

		if (count > 33000)
		{
			errs	= 1;
			break;
		}
	}

	wait_for_irq(&_qty);
	return(errs);
}



//*****************************************************************************
int tx_fifo_full_test(int fd, int irq32)
{
	int	errs	= 0;

	gsc_label("Tx FIFO Full");


	if (irq32 == SIO4_FEATURE_YES)
	{
		errs	+= _irq_setup(fd);
		errs	+= _irq_trigger(fd);
		errs	+= (_qty > 0) ? 0 : 1;
		errs	+= _irq_reset(fd);
		printf("%s\n", errs ? "FAIL <---" : "PASS");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	return(errs ? 1 : 0);
}


