// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/rx_envelope.c $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: source file

#include "main.h"



// #define ********************************************************************

#define	INT_NOTIFY_RX_ENV		SIO4_INT_NOTIFY_SYNC_DETECTED



// variables ******************************************************************

static	int	_qty;



/******************************************************************************
*
*	Function:	_irq_reset
*
*	Purpose:
*
*		Clean things up after we're done.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_reset(int fd)
{
	int	errs	= 0;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Turn off asynchronous interrupt notification.
	errs	+= notify_disable(fd);

	// Disable the interrupt.
	errs	+= GSC_INT_ALL_DISABLE(fd);
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_setup
*
*	Purpose:
*
*		Set things up so generation of the interrupt will be detected.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_setup(int fd)
{
	int	errs	= 0;
	s32	index;
	int	status;

	// Reset the device.
	status	= sio4_channel_reset(fd, 0);
	errs	+= status ? 1 : 0;

	// Select defaults.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, 0, 0xFFFFFFFF);

	// Enable the transceivers.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x80000000);

	// Enable the external loop back.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x20000000);

	// Set the TxE signal as GPIO low output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000020);

	// Enable the transmitter.
	errs	+= reg_mod(fd, SIO4_GSC_CSR, ~0, 0x02000000);

	// Enable the receiver.
	errs	+= reg_mod(fd, SIO4_GSC_CSR, ~0, 0x01000000);

	// Setup asynchronous interrupt notification.
	errs	+= notify_enable(fd, INT_NOTIFY_RX_ENV, &_qty);

	// Enable the interrupt.
	errs	+= sio4_feature_test(fd, SIO4_FEATURE_INDEX_CHANNEL, &index, 0);
	errs	+= reg_write(fd, SIO4_GSC_ICR, 0x0001 << (4 * index));
	return(errs);
}



/******************************************************************************
*
*	Function:	_irq_trigger
*
*	Purpose:
*
*		Trigger the interrupt.
*
*	Arguments:
*
*		fd		The file descriptor for the channel to access.
*
*	Returned:
*
*		>= 0	The number of errors seen.
*
******************************************************************************/

static int _irq_trigger(int fd)
{
	int	errs	= 0;

	// Set the TxE signal as GPIO low output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000020);

	// Set the TxE signal as GPIO high output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000030);

	// Set the TxE signal as GPIO low output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000020);

	// Set the TxE signal as GPIO high output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000030);

	// Set the TxE signal as GPIO low output.
	errs	+= reg_mod(fd, SIO4_GSC_PSRCR, ~0, 0x00000020);

	if (errs == 0)
		wait_for_irq(&_qty);

	return(errs);
}



//*****************************************************************************
int rx_envelope_test(int fd, int fw_type)
{
	int	errs	= 0;

	gsc_label("Rx Evenlope");

	if (fw_type == SIO4_FW_TYPE_CONFIG_SYNC)
	{
		errs	+= _irq_setup(fd);
		errs	+= _irq_trigger(fd);
		errs	+= (_qty > 0) ? 0 : 1;
		errs	+= _irq_reset(fd);
		printf("%s\n", errs ? "FAIL <---" : "PASS");
	}
	else
	{
		printf("SKIPPED  (Not supported.)\n");
	}

	return(errs ? 1 : 0);
}


