// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/samples/irq/main.h $
// $Rev: 53079 $
// $Date: 2023-06-13 10:07:58 -0500 (Tue, 13 Jun 2023) $

// SIO4: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <math.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// macros *********************************************************************

#define	GSC_ICR_MOD(h,v,m)					reg_mod((h),SIO4_GSC_ICR,(v),(m))
#define	GSC_ICR_WRITE(h,v)					reg_write((h),SIO4_GSC_ICR,(v))

#define	GSC_INT_ALL_DISABLE(h)				GSC_ICR_WRITE((h),0)

#define	GSC_LOCAL_INT_ENABLE(h)				GSC_ICR_MOD((h),0x8,0x8)
#define	GSC_LOCAL_INT_DISABLE(h)			GSC_ICR_MOD((h),0x0,0x8)

#define	USC_DCCR_MOD(h,v,m)					reg_mod((h),SIO4_USC_DCCR,(v),(m))
#define	USC_ICR_MOD(h,v,m)					reg_mod((h),SIO4_USC_ICR,(v),(m))
#define	USC_ICR_WRITE(h,v)					reg_write((h),SIO4_USC_ICR,(v))
#define	USC_MISR_MOD(h,v,m)					reg_mod((h),SIO4_USC_MISR,(v),(m))
#define	USC_RCSR_MOD(h,v,m)					reg_mod((h),SIO4_USC_RCSR,(v),(m))
#define	USC_RICR_MOD(h,v,m)					reg_mod((h),SIO4_USC_RICR,(v),(m))
#define	USC_SICR_MOD(h,v,m)					reg_mod((h),SIO4_USC_SICR,(v),(m))
#define	USC_SICR_WRITE(h,v)					reg_write((h),SIO4_USC_SICR,(v))
#define	USC_TCSR_MOD(h,v,m)					reg_mod((h),SIO4_USC_TCSR,(v),(m))
#define	USC_TICR_MOD(h,v,m)					reg_mod((h),SIO4_USC_TICR,(v),(m))

#define	USC_MASTER_INT_ENABLE(h)			USC_ICR_MOD((h),0x8000,0x8000)
#define	USC_MASTER_INT_DISABLE(h)			USC_ICR_MOD((h),0x0000,0x8000)

#define	USC_RX_DATA_INT_ENABLE(h)			USC_ICR_MOD((h), 0xD0,0xD0)
#define	USC_RX_DATA_INT_DISABLE(h)			USC_ICR_MOD((h), 0x90,0xD0)
#define	USC_RX_DATA_INT_CLEAR(h)			USC_DCCR_MOD((h),0x50,0xD0)
#define	USC_RX_STATUS_INT_ENABLE(h)			USC_ICR_MOD((h), 0xE0,0xE0)
#define	USC_RX_STATUS_INT_DISABLE(h)		USC_ICR_MOD((h), 0xA0,0xE0)
#define	USC_RX_STATUS_INT_CLEAR(h)			USC_DCCR_MOD((h),0x60,0xE0)
#define	USC_TX_DATA_INT_ENABLE(h)			USC_ICR_MOD((h), 0xC4,0xC4)
#define	USC_TX_DATA_INT_DISABLE(h)			USC_ICR_MOD((h), 0x84,0xC4)
#define	USC_TX_DATA_INT_CLEAR(h)			USC_DCCR_MOD((h),0x44,0xC4)
#define	USC_TX_STATUS_INT_ENABLE(h)			USC_ICR_MOD((h), 0xC8,0xC8)
#define	USC_TX_STATUS_INT_DISABLE(h)		USC_ICR_MOD((h), 0x88,0xC8)
#define	USC_TX_STATUS_INT_CLEAR(h)			USC_DCCR_MOD((h),0x48,0xC8)
#define	USC_IOP_INT_ENABLE(h)				USC_ICR_MOD((h), 0xC2,0xC2)
#define	USC_IOP_INT_DISABLE(h)				USC_ICR_MOD((h), 0x82,0xC2)
#define	USC_IOP_INT_CLEAR(h)				USC_DCCR_MOD((h),0x42,0xC2)
#define	USC_MISC_INT_ENABLE(h)				USC_ICR_MOD((h), 0xC1,0xC1)
#define	USC_MISC_INT_DISABLE(h)				USC_ICR_MOD((h), 0x81,0xC1)
#define	USC_MISC_INT_CLEAR(h)				USC_DCCR_MOD((h),0x41,0xC1)

#define	USC_RX_EXIT_HUNT_INT_ARM(h)			USC_RICR_MOD((h),0x0080,0x0080)
#define	USC_RX_EXIT_HUNT_INT_DISARM(h)		USC_RICR_MOD((h),0x0000,0x0080)
#define	USC_RX_EXIT_HUNT_STATUS_CLR(h)		USC_RCSR_MOD((h),0x0080,0x0080)
#define	USC_RX_IDLE_RCVD_INT_ARM(h)			USC_RICR_MOD((h),0x0040,0x0040)
#define	USC_RX_IDLE_RCVD_INT_DISARM(h)		USC_RICR_MOD((h),0x0000,0x0040)
#define	USC_RX_IDLE_RCVD_STATUS_CLR(h)		USC_RCSR_MOD((h),0x0040,0x0040)
#define	USC_RX_BRK_ABRT_INT_ARM(h)			USC_RICR_MOD((h),0x0020,0x0020)
#define	USC_RX_BRK_ABRT_INT_DISARM(h)		USC_RICR_MOD((h),0x0000,0x0020)
#define	USC_RX_BRK_ABRT_STATUS_CLR(h)		USC_RCSR_MOD((h),0x0020,0x0020)
#define	USC_RX_BOUND_INT_ARM(h)				USC_RICR_MOD((h),0x0010,0x0010)
#define	USC_RX_BOUND_INT_DISARM(h)			USC_RICR_MOD((h),0x0000,0x0010)
#define	USC_RX_BOUND_STATUS_CLR(h)			USC_RCSR_MOD((h),0x0010,0x0010)
#define	USC_RX_ABORT_PE_INT_ARM(h)			USC_RICR_MOD((h),0x0004,0x0004)
#define	USC_RX_ABORT_PE_INT_DISARM(h)		USC_RICR_MOD((h),0x0000,0x0004)
#define	USC_RX_ABORT_PE_STATUS_CLR(h)		USC_RCSR_MOD((h),0x0004,0x0004)
#define	USC_RX_OVERRUN_INT_ARM(h)			USC_RICR_MOD((h),0x0002,0x0002)
#define	USC_RX_OVERRUN_INT_DISARM(h)		USC_RICR_MOD((h),0x0000,0x0002)
#define	USC_RX_OVERRUN_STATUS_CLR(h)		USC_RCSR_MOD((h),0x0002,0x0002)

#define	USC_TX_PRE_SENT_INT_ARM(h)			USC_TICR_MOD((h),0x0080,0x0080)
#define	USC_TX_PRE_SENT_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0080)
#define	USC_TX_PRE_SENT_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0080,0x0080)
#define	USC_TX_IDLE_SENT_INT_ARM(h)			USC_TICR_MOD((h),0x0040,0x0040)
#define	USC_TX_IDLE_SENT_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0040)
#define	USC_TX_IDLE_SENT_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0040,0x0040)
#define	USC_TX_ABORT_SENT_INT_ARM(h)		USC_TICR_MOD((h),0x0020,0x0020)
#define	USC_TX_ABORT_SENT_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0020)
#define	USC_TX_ABORT_SENT_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0020,0x0020)
#define	USC_TX_END_SENT_INT_ARM(h)			USC_TICR_MOD((h),0x0010,0x0010)
#define	USC_TX_END_SENT_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0010)
#define	USC_TX_END_SENT_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0010,0x0010)
#define	USC_TX_CRC_SENT_INT_ARM(h)			USC_TICR_MOD((h),0x0008,0x0008)
#define	USC_TX_CRC_SENT_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0008)
#define	USC_TX_CRC_SENT_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0008,0x0008)
#define	USC_TX_UNDER_RUN_INT_ARM(h)			USC_TICR_MOD((h),0x0002,0x0002)
#define	USC_TX_UNDER_RUN_INT_DISARM(h)		USC_TICR_MOD((h),0x0000,0x0002)
#define	USC_TX_UNDER_RUN_STATUS_CLR(h)		USC_TCSR_MOD((h),0x0002,0x0002)

#define	USC_RXC_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x8000,0x8000)
#define	USC_RXC_DN_INT_ARM(h)				USC_SICR_MOD((h),0x8000,0x8000)
#define	USC_RXC_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x8000)
#define	USC_RXC_UP_INT_ARM(h)				USC_SICR_MOD((h),0x4000,0x4000)
#define	USC_RXC_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x4000)
#define	USC_TXC_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x2000,0x2000)
#define	USC_TXC_DN_INT_ARM(h)				USC_SICR_MOD((h),0x2000,0x2000)
#define	USC_TXC_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x2000)
#define	USC_TXC_UP_INT_ARM(h)				USC_SICR_MOD((h),0x1000,0x1000)
#define	USC_TXC_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x1000)
#define	USC_RXR_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x0800,0x0800)
#define	USC_RXR_DN_INT_ARM(h)				USC_SICR_MOD((h),0x0800,0x0800)
#define	USC_RXR_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0800)
#define	USC_RXR_UP_INT_ARM(h)				USC_SICR_MOD((h),0x0400,0x0400)
#define	USC_RXR_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0400)
#define	USC_TXR_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x0200,0x0200)
#define	USC_TXR_DN_INT_ARM(h)				USC_SICR_MOD((h),0x0200,0x0200)
#define	USC_TXR_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0200)
#define	USC_TXR_UP_INT_ARM(h)				USC_SICR_MOD((h),0x0100,0x0100)
#define	USC_TXR_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0100)
#define	USC_DCD_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x0080,0x0080)
#define	USC_DCD_DN_INT_ARM(h)				USC_SICR_MOD((h),0x0080,0x0080)
#define	USC_DCD_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0080)
#define	USC_DCD_UP_INT_ARM(h)				USC_SICR_MOD((h),0x0040,0x0040)
#define	USC_DCD_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0040)
#define	USC_CTS_STATUS_CLEAR(h)				USC_MISR_MOD((h),0x0020,0x0020)
#define	USC_CTS_DN_INT_ARM(h)				USC_SICR_MOD((h),0x0020,0x0020)
#define	USC_CTS_DN_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0020)
#define	USC_CTS_UP_INT_ARM(h)				USC_SICR_MOD((h),0x0010,0x0010)
#define	USC_CTS_UP_INT_DISARM(h)			USC_SICR_MOD((h),0x0000,0x0010)

#define	USC_RCC_UNDER_INT_ARM(h)			USC_SICR_MOD((h),0x8,0x8)
#define	USC_RCC_UNDER_INT_DISARM(h)			USC_SICR_MOD((h),0x0,0x8)
#define	USC_RCC_UNDER_STATUS_CLR(h)			USC_MISR_MOD((h),0x8,0x8)
#define	USC_DPLL_DESYNC_INT_ARM(h)			USC_SICR_MOD((h),0x4,0x4)
#define	USC_DPLL_DESYNC_INT_DISARM(h)		USC_SICR_MOD((h),0x0,0x4)
#define	USC_DPLL_DESYNC_STATUS_CLR(h)		USC_MISR_MOD((h),0x4,0x4)
#define	USC_BRG1_ZERO_INT_ARM(h)			USC_SICR_MOD((h),0x2,0x2)
#define	USC_BRG1_ZERO_INT_DISARM(h)			USC_SICR_MOD((h),0x0,0x2)
#define	USC_BRG1_ZERO_STATUS_CLR(h)			USC_MISR_MOD((h),0x2,0x2)
#define	USC_BRG0_ZERO_INT_ARM(h)			USC_SICR_MOD((h),0x1,0x1)
#define	USC_BRG0_ZERO_INT_DISARM(h)			USC_SICR_MOD((h),0x0,0x1)
#define	USC_BRG0_ZERO_STATUS_CLR(h)			USC_MISR_MOD((h),0x1,0x1)



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

} args_t;

typedef enum
{
	USC_IRQ_NONE,

	USC_IRQ_RX_EXITED_HUNT,		// Rx Status
	USC_IRQ_RX_IDLE_RECEIVED,	// Rx Status
	USC_IRQ_RX_BREAK_ABORT,		// Rx Status
	USC_IRQ_RX_BOUND,			// Rx Status
	USC_IRQ_RX_ABORT_PE,		// Rx Status
	USC_IRQ_RX_OVERRUN,			// Rx Status

	USC_IRQ_RX_DATA,			// Rx Data

	USC_IRQ_TX_PRE_SENT,		// Tx Status
	USC_IRQ_TX_IDLE_SENT,		// Tx Status
	USC_IRQ_TX_ABORT_SENT,		// Tx Status
	USC_IRQ_TX_END_SENT,		// Tx Status
	USC_IRQ_TX_CRC_SENT,		// Tx Status
	USC_IRQ_TX_UNDER_RUN,		// Tx Status

	USC_IRQ_TX_DATA,			// Tx Data

	USC_IRQ_RXC_DN,				// I/O Pin
	USC_IRQ_RXC_UP,				// I/O Pin
	USC_IRQ_TXC_DN,				// I/O Pin
	USC_IRQ_TXC_UP,				// I/O Pin
	USC_IRQ_RXR_DN,				// I/O Pin
	USC_IRQ_RXR_UP,				// I/O Pin
	USC_IRQ_TXR_DN,				// I/O Pin
	USC_IRQ_TXR_UP,				// I/O Pin
	USC_IRQ_DCD_DN,				// I/O Pin
	USC_IRQ_DCD_UP,				// I/O Pin
	USC_IRQ_CTS_DN,				// I/O Pin
	USC_IRQ_CTS_UP,				// I/O Pin

	USC_IRQ_RCC_UNDER,			// Misc
	USC_IRQ_DPLL_DESYNC,		// Misc
	USC_IRQ_BRG0_ZERO,			// Misc
	USC_IRQ_BRG1_ZERO			// Misc
} usc_irq_t;



// prototypes *****************************************************************

int		notify_disable(int fd);
int		notify_enable(int fd, u8 flag, int* qty);

int		perform_tests(const args_t* args);

int		rx_envelope_test(int fd, int fw_type);
int		rx_fifo_almost_full_test(int fd);
int		rx_fifo_empty_test(int fd, int irq32);
int		rx_fifo_full_test(int fd, int irq32);
int		rx_spare_test(int fd, int fw_type);

int		sync_detected_test(int fd, int fw_type);

int		tx_fifo_almost_empty_test(int fd);
int		tx_fifo_empty_test(int fd, int irq32);
int		tx_fifo_full_test(int fd, int irq32);

int		usc_brg0_zero_test(int fd);
int		usc_brg1_zero_test(int fd);
int		usc_cts_down_test(int fd);
int		usc_cts_up_test(int fd);
int		usc_dcd_down_test(int fd);
int		usc_dcd_up_test(int fd);
int		usc_dpll_desync_test(int fd);
int		usc_notify_disable(int fd);
int		usc_notify_enable(int fd, usc_irq_t irq, int* qty);
int		usc_rcc_underrun_test(int fd);
int		usc_rx_abort_pe_test(int fd);
int		usc_rx_bound_test(int fd);
int		usc_rx_break_abort_test(int fd);
int		usc_rx_data_test(int fd);
int		usc_rx_exited_hunt_test(int fd);
int		usc_rx_idle_received_test(int fd);
int		usc_rx_overrun_test(int fd);
int		usc_rxc_down_test(int fd);
int		usc_rxc_up_test(int fd);
int		usc_rxreq_down_test(int fd);
int		usc_rxreq_up_test(int fd);
int		usc_tests(int fd, int fw_type);
int		usc_tx_abort_sent_test(int fd);
int		usc_tx_crc_sent_test(int fd);
int		usc_tx_data_test(int fd);
int		usc_tx_eof_eom_sent_test(int fd);
int		usc_tx_idle_sent_test(int fd);
int		usc_tx_preamble_sent_test(int fd);
int		usc_tx_underrun_test(int fd);
int		usc_txc_down_test(int fd);
int		usc_txc_up_test(int fd);
int		usc_txreq_down_test(int fd);
int		usc_txreq_up_test(int fd);

void	wait_for_irq(int* qty);



#endif
