// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/include/util_monosync.h $
// $Rev: 53093 $
// $Date: 2023-06-13 10:20:11 -0500 (Tue, 13 Jun 2023) $

// SIO4: Utilities: Monosync header file

#ifndef	__UTIL_MONOSYNC_H__
#define	__UTIL_MONOSYNC_H__

#include "sio4.h"



// data types *****************************************************************

typedef struct
{
	struct
	{
		struct
		{
			int	enable;					// Yes ot no.
			int	dce;					// Yes or no.
		} dcedte;

		struct
		{
			int	config;					// upper/lower routing
		} legacy;						// When DCE/DTE isn't available.

		int		cts;
		int		dcd;
		int		xceiver;
	} cable;

	struct
	{
		int		enable;					// Enable loopback mode?
	} loopback;

	struct
	{
		s32		ref_comp;				// Computed based on desired baud.
		s32		ref_default;			// The starting frequency.
		s32		ref_got;				// What we got (not measured).
	} osc;

	struct
	{
		int		ae;						// RAR: Almost Empty
		int		af;						// RAR: Almost Full
		long	baud_comp;				// The computed baudrate.
		long	baud_want;				// The desired baudrate.
		int		char_size;				// see macros
		int		crc_enable;				// yes or no
		int		crc_start_value;		// 1's or 0's
		int		crc_type;				// see macros
		int		dpll_sync_edge;			// see macros
		int		dpll_use;				// Use the DPLL?
		int		enable;					// Enable after configuring?
		int		encoding;				// RMR: see macros
		int		fifo_full_chan;			// Overrun or halt when full? channel specific
		int		fifo_full_glb;			// Overrun or halt when full? GLOBAL! READ USER MANUAL!
		int		frame_size_max;
		int		io_mode;				// PIO, DMA, DMDMA
		int		io_mode_force;			// Use DMDMA even w/o SCD.
		int		parity_enable;			// yes or no
		int		parity_type;			// see macros
		int		status_block_size;
		int		sync_char_act;			// see macros
		int		sync_char_size;			// see macros
		char	sync_value;				// any value per size
		int		timeout;				// In seconds.
		int		usc_rxc_config;			// The RxC pin.
		long	usc_rxc_rate;			// Clock rate on RxC.
	} rx;

	struct
	{
		int		ae;						// TAR: Almost Empty
		int		af;						// TAR: Almost Full
		long	baud_comp;				// The computed baudrate.
		long	baud_want;				// The desired baudrate.
		int		cable_clock;			// Cable Clock Source
		int		cable_data;				// Cable Data Source
		int		char_size;				// see macros
		int		control_block_size;
		int		crc_enable;				// yes or no
		int		crc_send_at_eof;		// yes or no
		int		crc_send_on_underrun;	// yes or no
		int		crc_start_value;		// 1's or 0's
		int		crc_type;				// see macros
		int		enable;					// Enable after configuring?
		int		encoding;				// TMR: see macros
		int		frame_size_max;
		int		idle_output;			// TCSR.TxIdle
		int		io_mode;				// PIO, DMA, DMDMA
		int		io_mode_force;			// Use DMDMA even w/o SCD.
		int		parity_enable;			// yes or no
		int		parity_type;			// see macros
		int		preamble_pattern;		// see macros
		int		preamble_send;			// yes or no
		int		preamble_size;			// see macros
		int		sync_char_size;			// see macros
		char	sync_value;				// any value per size
		int		timeout;				// In seconds.
		int		usc_txc_config;			// The TxC pin configuration.
		long	usc_txc_rate;			// Clock rate on TxC.
	} tx;

} sio4_monosync_t;



// prototypes *****************************************************************

int		sio4_monosync_config(int fd, sio4_monosync_t* data);
void	sio4_monosync_t_init(sio4_monosync_t* data);



#endif
