// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/include/sio4_sync.h $
// $Rev: 53093 $
// $Date: 2023-06-13 10:20:11 -0500 (Tue, 13 Jun 2023) $

// SIO4: SYNC Protocol Library: header file

#ifndef	__SIO4_SYNC_H__
#define	__SIO4_SYNC_H__

#include "sio4.h"



// macros *********************************************************************

// Control/Status Register
#define	SIO4_SYNC_CSR_RX_ENABLE				0x01000000
#define	SIO4_SYNC_CSR_TX_ENABLE				0x02000000
#define	SIO4_SYNC_CSR_TX_AUTO_DIS			0x04000000
#define	SIO4_SYNC_CSR_RX_LSB_FIRST			0x08000000
#define	SIO4_SYNC_CSR_TX_LSB_FIRST			0x10000000
#define	SIO4_SYNC_CSR_RX_CNT_ERR_RST		0x20000000
#define	SIO4_SYNC_CSR_RX_CNT_ERR_STS		0x80000000

// Pin Source Register
#define	SIO4_SYNC_PSRCR_TXC					0x00000007 // Tx Clock
#define	SIO4_SYNC_PSRCR_TXC_IDLE			0x00000008 // Tx Clock Idle
#define	SIO4_SYNC_PSRCR_TXE					0x00000030 // Tx Envelope
#define	SIO4_SYNC_PSRCR_TXD					0x000001C0 // Tx Data
#define	SIO4_SYNC_PSRCR_TXAC				0x00000600 // Tx Aux Clock
#define	SIO4_SYNC_PSRCR_TXSP				0x00001800 // Tx Spare
#define	SIO4_SYNC_PSRCR_RXC					0x00002000 // Rx Clock
#define	SIO4_SYNC_PSRCR_RXE					0x0000C000 // Rx Envelope
#define	SIO4_SYNC_PSRCR_RXD					0x00030000 // Rx Data
#define	SIO4_SYNC_PSRCR_LB_INT				0x00800000 // Internal Loopback
#define	SIO4_SYNC_PSRCR_DCE_EN				0x10000000 // DCE Enable (if D31 set)
#define	SIO4_SYNC_PSRCR_LB_EXT				0x20000000 // External Loopback
#define	SIO4_SYNC_PSRCR_DCE_DTE_EN			0x80000000 // DCE/DTE Enable

// Pin Status Register
#define	SIO4_SYNC_PSTSR_GPIO				0x000003FF // D0-D9



// data types *****************************************************************

typedef struct
{
	int		dce_enable;	// 0 = No, !0 = Yes (Precidence over DTE.)
	int		dte_enable;	// 0 = No, !0 = Yes (If DCE disabled.)

	struct
	{
		int	enable;		// 0 = No (disble), !0 = Yes (enable)
		int	internal;	// 0 = No (Extern), !0 = Yes (Intern)
	} lb;
} sio4_sync_t;

typedef struct
{
	int		enable;		// 0 = disable, !0 = enable
	int		lsbf;		// 0 = MSB First, !0 = LSB first
	int		reset;		// 0 = no error/reset, !0 = error/reset
	__u16	word_size;	// Size of received Rx word. READ-ONLY

	struct
	{
		int	high;		// 0 = Active Low, !0 = Active High
	} clock;

	struct
	{
		int	enable;		// 0 = No (no envelope), !0 = Yes (Activate)
		int	high;		// 0 = Active Low, !0 = Active High
	} env;

	struct
	{
		int	high;		// 0 = Active Low, !0 = Active High
	} data;
} sio4_sync_rx_t;

typedef struct
{
	int		enable;		// 0 = disable, !0 = enable
	int		auto_dis;	// 0 = No (keep enabled), !0 = Yes (disable)
	int		lsbf;		// 0 = MSB First, !0 = LSB first
	__u16	word_size;	// Size of Tx word in bits.
	__u16	gap_size;	// Size of gap between Tx words.

	struct
	{
		int	clock;		// 0 = No (GPIO), !0 = Yes (Tx Clock)
		int	ext;		// 0 = No (osc / 2), !0 = Yes (Rx Aux Clock)
		int	high;		// 0 = Active Low, !0 = Active High
		int	idle;		// 0 = Tri-State when Idle, !0 = Run
	} clock;

	struct
	{
		int	env;		// 0 = No (GPIO), !0 = Yes (Tx Env)
		int	high;		// 0 = Active Low, !0 = Active High
	} env;

	struct
	{
		int	data;		// 0 = No (GPIO), !0 = Yes (Tx Data)
		int	high;		// 0 = Active Low, !0 = Active High
	} data;

	struct
	{
		int	enable;		// 0 = No (tri-state), !0 = Yes (Activate)
		int	clock;		// 0 = No (GPIO), !0 = Yes (osc / 2)
		int	high;		// 0 = Active Low, !0 = Active High
	} aux_clock;

	struct
	{
		int	enable;		// 0 = No (tri-state), !0 = Yes (GPIO)
		int	high;		// 0 = Active Low, !0 = Active High
	} spare;
} sio4_sync_tx_t;



// functions ******************************************************************

int		sio4_sync_get(int fd, sio4_sync_t* sync);
int		sio4_sync_set(int fd, const sio4_sync_t* sync);

int		sio4_sync_gpio_rx(int fd, __u32* value);
int		sio4_sync_gpio_tx(int fd, __u32 value);

int		sio4_sync_rx_get(int fd, sio4_sync_rx_t* rx);
int		sio4_sync_rx_set(int fd, const sio4_sync_rx_t* rx);

int		sio4_sync_tx_get(int fd, sio4_sync_tx_t* tx);
int		sio4_sync_tx_set(int fd, const sio4_sync_tx_t* tx);



#endif
