// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/include/sio4_async.h $
// $Rev: 53093 $
// $Date: 2023-06-13 10:20:11 -0500 (Tue, 13 Jun 2023) $

// SIO4: Asynchronous Protocol Library: header file

#ifndef	__SIO4_ASYNC_H__
#define	__SIO4_ASYNC_H__

#include "sio4.h"



// data types *****************************************************************

typedef struct
{
	struct
	{
		struct
		{
			int	enable;			// Yes ot no.
			int	dce;			// Yes or no.
		} dcedte;

		struct
		{
			int	config;			// upper/lower routing
		} legacy;				// When DCE/DTE isn't available.

		int		cts;
		int		dcd;
		int		xceiver;
	} cable;

	struct
	{
		int		enable;			// Enable loopback mode?
		int		internal;		// Use internal loopback when enabled?
								// It is always external with DCE/DTE.
	} loopback;

	struct
	{
		int		ae;				// RAR: Almost Empty
		int		af;				// RAR: Almost Full
		long	baud_comp;		// The computed baudrate.
		long	baud_want;		// The desired baudrate.
		int		char_size;		// RMR: see macros
		int		enable;			// Enable receiver after configuring?
		int		encoding;		// RMR: see macros
		int		fifo_full_chan;	// Overrun or halt when full? channel specific
		int		fifo_full_glb;	// Overrun or halt when full? GLOBAL! READ USER MANUAL!
		int		io_mode;		// PIO, DMA, DMDMA
		int		io_mode_force;	// Use DMDMA even w/o SCD.
		int		parity_enable;	// RMR: yes or no
		int		parity_type;	// RMR: see macros
		int		timeout;		// In seconds.
		int		usc_rxc_config;	// The RxC pin.
		long	usc_rxc_rate;	// Clock rate on RxC.
	} rx;

	struct
	{
		int		ae;				// TAR: Almost Empty
		int		af;				// TAR: Almost Full
		long	baud_comp;		// The computed baudrate.
		long	baud_want;		// The desired baudrate.
		int		cable_clock;	// Cable Clock Source
		int		cable_data;		// Cable Data Source
		int		char_size;		// TMR: see macros
		int		enable;			// Enable transmitter after configuring?
		int		encoding;		// TMR: see macros
		int		idle_output;	// TCSR.TxIdle: see macros
		int		io_mode;		// PIO, DMA, DMDMA
		int		io_mode_force;	// Use DMDMA even w/o SCD.
		int		parity_enable;	// TMR: yes or no
		int		parity_type;	// TMR: see macros
		long	shave_bits;		// CCR: see macros (stop bits)
		int		stop_bits;		// see macros
		int		timeout;		// In seconds.
		int		usc_txc_config;	// The TxC pin configuration.
		long	usc_txc_rate;	// Clock rate on TxC.
	} tx;

	struct
	{
		__s32	ref_comp;		// Computed based on desired baud.
		__s32	ref_default;	// The starting frequency.
		__s32	ref_got;		// What we got (not measured).
	} osc;

} sio4_async_t;



// prototypes *****************************************************************

int		sio4_async_config(int fd, sio4_async_t* async, int errs, int loud);
void	sio4_async_t_init(sio4_async_t* async);



#endif
