// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/driver/pci_plx/gsc_pci9060es.h $
// $Rev: 50964 $
// $Date: 2022-04-25 08:31:03 -0500 (Mon, 25 Apr 2022) $

// OS & Device Independent: Device Driver: PLX: header file

#ifndef	__GSC_PCI9060ES_H__
#define	__GSC_PCI9060ES_H__

#include "gsc_common.h"



// macros *********************************************************************

#define	GSC_PCI_9060ES_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_PCI,(s),(o))
#define	GSC_PLX_9060ES_ENCODE(s,o)	GSC_REG_ENCODE(GSC_REG_TYPE_BAR0,(s),(o))

// PLX PCI9060ES PCI Configuration Registers
#define	GSC_PCI_9060ES_VIDR			GSC_PCI_9060ES_ENCODE(2, 0x00)
#define	GSC_PCI_9060ES_DIDR			GSC_PCI_9060ES_ENCODE(2, 0x02)
#define	GSC_PCI_9060ES_CR			GSC_PCI_9060ES_ENCODE(2, 0x04)
#define	GSC_PCI_9060ES_SR			GSC_PCI_9060ES_ENCODE(2, 0x06)
#define	GSC_PCI_9060ES_REV			GSC_PCI_9060ES_ENCODE(1, 0x08)
#define	GSC_PCI_9060ES_CCR			GSC_PCI_9060ES_ENCODE(3, 0x09)
#define	GSC_PCI_9060ES_CLSR			GSC_PCI_9060ES_ENCODE(1, 0x0C)
#define	GSC_PCI_9060ES_LTR			GSC_PCI_9060ES_ENCODE(1, 0x0D)
#define	GSC_PCI_9060ES_HTR			GSC_PCI_9060ES_ENCODE(1, 0x0E)
#define	GSC_PCI_9060ES_BISTR		GSC_PCI_9060ES_ENCODE(1, 0x0F)
#define	GSC_PCI_9060ES_BAR0			GSC_PCI_9060ES_ENCODE(4, 0x10)
#define	GSC_PCI_9060ES_BAR1			GSC_PCI_9060ES_ENCODE(4, 0x14)
#define	GSC_PCI_9060ES_BAR2			GSC_PCI_9060ES_ENCODE(4, 0x18)
#define	GSC_PCI_9060ES_BAR3			GSC_PCI_9060ES_ENCODE(4, 0x1C)
#define	GSC_PCI_9060ES_BAR4			GSC_PCI_9060ES_ENCODE(4, 0x20)
#define	GSC_PCI_9060ES_BAR5			GSC_PCI_9060ES_ENCODE(4, 0x24)
#define	GSC_PCI_9060ES_SVID			GSC_PCI_9060ES_ENCODE(2, 0x2C)
#define	GSC_PCI_9060ES_SID			GSC_PCI_9060ES_ENCODE(2, 0x2E)
#define	GSC_PCI_9060ES_ERBAR		GSC_PCI_9060ES_ENCODE(4, 0x30)
#define	GSC_PCI_9060ES_ILR			GSC_PCI_9060ES_ENCODE(1, 0x3C)
#define	GSC_PCI_9060ES_IPR			GSC_PCI_9060ES_ENCODE(1, 0x3D)
#define	GSC_PCI_9060ES_MGR			GSC_PCI_9060ES_ENCODE(1, 0x3E)
#define	GSC_PCI_9060ES_MLR			GSC_PCI_9060ES_ENCODE(1, 0x3F)

// PLX PCI9060ES feature set registers: Local Configuration Registers
#define	GSC_PLX_9060ES_LAS0RR		GSC_PLX_9060ES_ENCODE(4, 0x00)
#define	GSC_PLX_9060ES_LAS0BA		GSC_PLX_9060ES_ENCODE(4, 0x04)
#define	GSC_PLX_9060ES_LARBR		GSC_PLX_9060ES_ENCODE(4, 0x08)
#define	GSC_PLX_9060ES_BIGEND		GSC_PLX_9060ES_ENCODE(4, 0x0C)
#define	GSC_PLX_9060ES_EROMRR		GSC_PLX_9060ES_ENCODE(4, 0x10)
#define	GSC_PLX_9060ES_EROMBA		GSC_PLX_9060ES_ENCODE(4, 0x14)
#define	GSC_PLX_9060ES_LBRD0		GSC_PLX_9060ES_ENCODE(4, 0x18)
#define	GSC_PLX_9060ES_DMRR			GSC_PLX_9060ES_ENCODE(4, 0x1C)
#define	GSC_PLX_9060ES_DMLBAM		GSC_PLX_9060ES_ENCODE(4, 0x20)
#define	GSC_PLX_9060ES_DMLBAI		GSC_PLX_9060ES_ENCODE(4, 0x24)
#define	GSC_PLX_9060ES_DMPBAM		GSC_PLX_9060ES_ENCODE(4, 0x28)
#define	GSC_PLX_9060ES_DMCFGA		GSC_PLX_9060ES_ENCODE(4, 0x2C)

// PLX PCI9060ES feature set registers: Runtime Registers
#define	GSC_PLX_9060ES_MBOX0		GSC_PLX_9060ES_ENCODE(4, 0x40)
#define	GSC_PLX_9060ES_MBOX1		GSC_PLX_9060ES_ENCODE(4, 0x44)
#define	GSC_PLX_9060ES_MBOX2		GSC_PLX_9060ES_ENCODE(4, 0x48)
#define	GSC_PLX_9060ES_MBOX3		GSC_PLX_9060ES_ENCODE(4, 0x4C)
#define	GSC_PLX_9060ES_P2LDBELL		GSC_PLX_9060ES_ENCODE(4, 0x60)
#define	GSC_PLX_9060ES_L2PDBELL		GSC_PLX_9060ES_ENCODE(4, 0x64)
#define	GSC_PLX_9060ES_INTCSR		GSC_PLX_9060ES_ENCODE(4, 0x68)
#define	GSC_PLX_9060ES_CNTRL		GSC_PLX_9060ES_ENCODE(4, 0x6C)
#define	GSC_PLX_9060ES_VIDR			GSC_PLX_9060ES_ENCODE(2, 0x70)	// PCI offset 0x00
#define	GSC_PLX_9060ES_DIDR			GSC_PLX_9060ES_ENCODE(2, 0x72)	// PCI offset 0x02



#endif
