// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/sio4_legacy.h $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: header file

#ifndef	__SIO4_LEGACY_H__
#define	__SIO4_LEGACY_H__

#include "sio4.h"



// This service is no longer available. Refer to errno for error information.
#define	SIO4_GET_LAST_ERROR					_IOWR('S', 1, SIO4_STATUS)

// This service and its data structure have been renamed.
#define	SIO4_SET_DMA_OPTIONS				SIO4_SET_USC_DMA_OPTIONS
typedef USC_DMA_OPTIONS	DMA_OPTIONS;

// This service is no longer available. Use the SIO4_TX/RX_IO_ABORT to
// perform the same task.
#define	SIO4_ABORT_DMA_TRANSFER				_IOW( 'S', 79, DMA_CHAN)

// This service is no longer available. Use the SIO4_TX/RX_IO_MODE_CONFIG
// IOCTL services and the read() and write() services.
#define	SIO4_SETUP_DMA_TRANSFER				_IOWR('S', 80, SETUP_DMA_TRANSFER)

// PCI Configuration Registers: PCI9080
#define	DEVICE_VENDOR_ID					SIO4_PCI_ENCODE(4,0x00)
#define	STATUS_COMMAND						SIO4_PCI_ENCODE(4,0x04)
#define	CLASS_CODE_REVISION_ID				SIO4_PCI_ENCODE(4,0x08)
#define	BIST_HDR_TYPE_LAT_CACHE_SIZE		SIO4_PCI_ENCODE(4,0x0C)
#define	PCI_MEM_BASE_ADDR					SIO4_PCI_ENCODE(4,0x10)
#define	PCI_IO_BASE_ADDR					SIO4_PCI_ENCODE(4,0x14)
#define	PCI_BASE_ADDR_0						SIO4_PCI_ENCODE(4,0x18)
#define	PCI_BASE_ADDR_1						SIO4_PCI_ENCODE(4,0x1C)
#define	CARDBUS_CIS_PTR						SIO4_PCI_ENCODE(4,0x28)
#define	SUBSYS_ID_VENDOR_ID					SIO4_PCI_ENCODE(4,0x2C)
#define	PCI_BASE_ADDR_LOC_ROM				SIO4_PCI_ENCODE(4,0x30)
#define	LAT_GNT_INT_PIN_LINE				SIO4_PCI_ENCODE(4,0x3C)



// PLX Feature Set Registers: PCI9080
// PCI9080: Local Configuration Registers
#define	PCI_TO_LOC_ADDR_0_RNG				SIO4_PLX_ENCODE(4,0x00)
#define	LOC_BASE_ADDR_REMAP_0				SIO4_PLX_ENCODE(4,0x04)
#define	MODE_ARBITRATION					SIO4_PLX_ENCODE(4,0x08)
#define	BIG_LITTLE_ENDIAN_DESC				SIO4_PLX_ENCODE(4,0x0C)
#define	PCI_TO_LOC_ROM_RNG					SIO4_PLX_ENCODE(4,0x10)
#define	LOC_BASE_ADDR_REMAP_EXP_ROM			SIO4_PLX_ENCODE(4,0x14)
#define	BUS_REG_DESC_0_FOR_PCI_LOC			SIO4_PLX_ENCODE(4,0x18)
#define	DIR_MASTER_TO_PCI_RNG				SIO4_PLX_ENCODE(4,0x1C)
#define	LOC_ADDR_FOR_DIR_MASTER_MEM			SIO4_PLX_ENCODE(4,0x20)
#define	LOC_ADDR_FOR_DIR_MASTER_IO			SIO4_PLX_ENCODE(4,0x24)
#define	PCI_ADDR_REMAP_DIR_MASTER			SIO4_PLX_ENCODE(4,0x28)
#define	PCI_CFG_ADDR_DIR_MASTER_IO			SIO4_PLX_ENCODE(4,0x2C)
#define	PCI_TO_LOC_ADDR_1_RNG				SIO4_PLX_ENCODE(4,0xF0)
#define	LOC_BASE_ADDR_REMAP_1				SIO4_PLX_ENCODE(4,0xF4)
#define	BUS_REG_DESC_1_FOR_PCI_LOC			SIO4_PLX_ENCODE(4,0xF8)

// PCI9080: Run Time Registers
#define	MAILBOX_REGISTER_0					SIO4_PLX_ENCODE(4,0x40)
#define	MAILBOX_REGISTER_1					SIO4_PLX_ENCODE(4,0x44)
#define	MAILBOX_REGISTER_2					SIO4_PLX_ENCODE(4,0x48)
#define	MAILBOX_REGISTER_3					SIO4_PLX_ENCODE(4,0x4C)
#define	MAILBOX_REGISTER_4					SIO4_PLX_ENCODE(4,0x50)
#define	MAILBOX_REGISTER_5					SIO4_PLX_ENCODE(4,0x54)
#define	MAILBOX_REGISTER_6					SIO4_PLX_ENCODE(4,0x58)
#define	MAILBOX_REGISTER_7					SIO4_PLX_ENCODE(4,0x5C)
#define	PCI_TO_LOC_DOORBELL					SIO4_PLX_ENCODE(4,0x60)
#define	LOC_TO_PCI_DOORBELL					SIO4_PLX_ENCODE(4,0x64)
#define	INT_CTRL_STATUS						SIO4_PLX_ENCODE(4,0x68)
#define	PROM_CTRL_CMD_CODES_CTRL			SIO4_PLX_ENCODE(4,0x6C)
#define	DEVICE_ID_VENDOR_ID					SIO4_PLX_ENCODE(4,0x70)
#define	REVISION_ID							SIO4_PLX_ENCODE(4,0x74)
#define	MAILBOX_REG_0						SIO4_PLX_ENCODE(4,0x78)
#define	MAILBOX_REG_1						SIO4_PLX_ENCODE(4,0x7C)

// PCI9080: DMA Registers
#define	DMA_CH_0_MODE						SIO4_PLX_ENCODE(4,0x80)
#define	DMA_CH_0_PCI_ADDR					SIO4_PLX_ENCODE(4,0x84)
#define	DMA_CH_0_LOCAL_ADDR					SIO4_PLX_ENCODE(4,0x88)
#define	DMA_CH_0_TRANS_BYTE_CNT				SIO4_PLX_ENCODE(4,0x8C)
#define	DMA_CH_0_DESC_PTR					SIO4_PLX_ENCODE(4,0x90)
#define	DMA_CH_1_MODE						SIO4_PLX_ENCODE(4,0x94)
#define	DMA_CH_1_PCI_ADDR					SIO4_PLX_ENCODE(4,0x98)
#define	DMA_CH_1_LOCAL_ADDR					SIO4_PLX_ENCODE(4,0x9C)
#define	DMA_CH_1_TRANS_BYTE_CNT				SIO4_PLX_ENCODE(4,0xA0)
#define	DMA_CH_1_DESC_PTR					SIO4_PLX_ENCODE(4,0xA4)
#define	DMA_CMD_STATUS						SIO4_PLX_ENCODE(4,0xA8)
#define	DMA_MODE_ARB_REG					SIO4_PLX_ENCODE(4,0xAC)
#define	DMA_THRESHOLD_REG					SIO4_PLX_ENCODE(4,0xB0)

// PCI9080: Messaging Queue Registers
#define	OUT_POST_Q_INT_STATUS				SIO4_PLX_ENCODE(4,0x30)
#define	OUT_POST_Q_INT_MASK					SIO4_PLX_ENCODE(4,0x34)
#define	IN_Q_PORT							SIO4_PLX_ENCODE(4,0x40)
#define	OUT_Q_PORT							SIO4_PLX_ENCODE(4,0x44)
#define	MSG_UNIT_CONFIG						SIO4_PLX_ENCODE(4,0xC0)
#define	Q_BASE_ADDR							SIO4_PLX_ENCODE(4,0xC4)
#define	IN_FREE_HEAD_PTR					SIO4_PLX_ENCODE(4,0xC8)
#define	IN_FREE_TAIL_PTR					SIO4_PLX_ENCODE(4,0xCC)
#define	IN_POST_HEAD_PTR					SIO4_PLX_ENCODE(4,0xD0)
#define	IN_POST_TAIL_PTR					SIO4_PLX_ENCODE(4,0xD4)
#define	OUT_FREE_HEAD_PTR					SIO4_PLX_ENCODE(4,0xD8)
#define	OUT_FREE_TAIL_PTR					SIO4_PLX_ENCODE(4,0xDC)
#define	OUT_POST_HEAD_PTR					SIO4_PLX_ENCODE(4,0xE0)
#define	OUT_POST_TAIL_PTR					SIO4_PLX_ENCODE(4,0xE4)
#define	Q_STATUS_CTRL_REG					SIO4_PLX_ENCODE(4,0xE8)



// GSC Registers
#define	BOARD_CONTROL						SIO4_GSC_BCR
#define	CLOCK_CONTROL						SIO4_GSC_CCR
#define	CONTROL_STATUS						SIO4_GSC_CSR
#define	FEATURES							SIO4_GSC_FR
#define	FIRMWARE_REVISION					SIO4_GSC_FRR
#define	FIFO								SIO4_GSC_FDR
#define	INTERRUPT_CONTROL					SIO4_GSC_ICR
#define	INTERRUPT_EDGE						SIO4_GSC_IELR
#define	INTERRUPT_HI_LO						SIO4_GSC_EHLR
#define	INTERRUPT_STATUS					SIO4_GSC_ISR
#define	RX_ALMOST							SIO4_GSC_RAR
#define	SYNC_CHARACTER						SIO4_GSC_SBR
#define	TX_ALMOST							SIO4_GSC_TAR

#define	SIO4_GSC_FWR						SIO4_GSC_FRR

#define	RESET_ZILOG							SIO4_GSC_CSR_ZIL_RST

// These are the masks for the Control Status Registers.
#define	RESET_TX_FIFO						SIO4_GSC_CSR_TFR
#define	RESET_RX_FIFO						SIO4_GSC_CSR_RFR
#define	ENABLE_TX_UPPER						SIO4_GSC_CSR_TDUE
#define	ENABLE_TX_LOWER						SIO4_GSC_CSR_TDLE
#define	ENABLE_RX_UPPER						SIO4_GSC_CSR_RDUE
#define	ENABLE_RX_LOWER						SIO4_GSC_CSR_RDLE
#define	PROGRAM_CLK							SIO4_GSC_PORAR
#define	TX_FIFO_EMPTY						SIO4_GSC_CSR_TFE
#define	TX_FIFO_ALMOST_EMPTY				SIO4_GSC_CSR_TFAE
#define	TX_FIFO_ALMOST_FULL					SIO4_GSC_CSR_TFAF
#define	TX_FIFO_FULL						SIO4_GSC_CSR_TFF
#define	RX_FIFO_EMPTY						SIO4_GSC_CSR_RFE
#define	RX_FIFO_ALMOST_EMPTY				SIO4_GSC_CSR_RFAE
#define	RX_FIFO_ALMOST_FULL					SIO4_GSC_CSR_RFAF
#define	RX_FIFO_FULL						SIO4_GSC_CSR_RFF

#define	FIFO_STATUS_MASK					0xFF00
#define	FIFO_STATUS_SHIFT					8
#define	EN_TX_CABLE_UPPER_SHIFT				2
#define	EN_TX_CABLE_LOWER_SHIFT				3
#define	EN_RX_CABLE_UPPER_SHIFT				4
#define	EN_RX_CABLE_LOWER_SHIFT				5
#define	EN_RX_TX_CABLE_MASK					0x3C

#define	ALMOST_EMPTY_MASK					SIO4_FIFO_ALOMST_EMPTY_MASK
#define	ALMOST_FULL_MASK					SIO4_FIFO_ALMOST_FULL_MASK
#define	ALMOST_EMPTY_SHIFT					SIO4_FIFO_ALMOST_EMPTY_SHIFT
#define	ALMOST_FULL_SHIFT					SIO4_FIFO_ALMOST_FULL_SHIFT

// These are the masks for the Interrupt Control and
// Interrupt Status Register

#define	CH1_INT_ON_SYNC						0x0001
#define	CH1_INT_ON_TX_FIFO_ALMOST_EMPTY		0x0002
#define	CH1_INT_ON_RX_FIFO_ALMOST_FULL		0x0004
#define	CH1_INT_ON_USC_INT					0x0008
#define	CH2_INT_ON_SYNC						0x0010
#define	CH2_INT_ON_TX_FIFO_ALMOST_EMPTY		0x0020
#define	CH2_INT_ON_RX_FIFO_ALMOST_FULL		0x0040
#define	CH2_INT_ON_USC_INT					0x0080
#define	CH3_INT_ON_SYNC						0x0100
#define	CH3_INT_ON_TX_FIFO_ALMOST_EMPTY		0x0200
#define	CH3_INT_ON_RX_FIFO_ALMOST_FULL		0x0400
#define	CH3_INT_ON_USC_INT					0x0800
#define	CH4_INT_ON_SYNC						0x1000
#define	CH4_INT_ON_TX_FIFO_ALMOST_EMPTY		0x2000
#define	CH4_INT_ON_RX_FIFO_ALMOST_FULL		0x4000
#define	CH4_INT_ON_USC_INT					0x8000

// These are used to find out which interrupt has occured.
#define	SIO4_INT_NOTIFY_TXFIFO_EMPTY		SIO4_INT_NOTIFY_TX_FIFO_AE
#define	SIO4_INT_NOTIFY_RXFIFO_FULL			SIO4_INT_NOTIFY_RX_FIFO_AF



// USC Registers
#define	CHANNEL_COMMAND_ADDRESS				SIO4_USC_CCAR
#define	CHANNEL_COMMAND_STATUS				SIO4_USC_CCSR
#define	CHANNEL_CONTROL						SIO4_USC_CCR
#define	CHANNEL_MODE						SIO4_USC_CMR
#define	CLOCK_MODE_CONTROL					SIO4_USC_CMCR
#define	DAISY_CHAIN_CONTROL					SIO4_USC_DCCR
#define	INTERRUPT_VECTOR					SIO4_USC_IVR
#define	IO_CONTROL							SIO4_USC_IOCR
#define	MISC_INTERRUPT_STATUS				SIO4_USC_MISR
#define	RECEIVE_CHARACTER_COUNT				SIO4_USC_RCCR
#define	RECEIVE_COMMAND_STATUS				SIO4_USC_RCSR
#define	RECEIVE_COUNT_LIMIT					SIO4_USC_RCLR
#define	RECEIVE_DATA						SIO4_USC_RDR
#define	RECEIVE_INTERRUPT_CONTROL			SIO4_USC_RICR
#define	RECEIVE_MODE						SIO4_USC_RMR
#define	RECEIVE_SYNC						SIO4_USC_RSR
#define	STATUS_INTERRUPT_CONTROL			SIO4_USC_SICR
#define	TEST_MODE_CONTROL					SIO4_USC_TMCR
#define	TEST_MODE_DATA						SIO4_USC_TMDR
#define	TIME_CONSTANT_0						SIO4_USC_TC0R
#define	TIME_CONSTANT_1						SIO4_USC_TC1R
#define	TRANSMIT_CHARACTER_COUNT			SIO4_USC_TCCR
#define	TRANSMIT_COMMAND_STATUS				SIO4_USC_TCSR
#define	TRANSMIT_COUNT_LIMIT				SIO4_USC_TCLR
#define	TRANSMIT_DATA						SIO4_USC_TDR
#define	TRANSMIT_INTERRUPT_CONTROL			SIO4_USC_TICR
#define	TRANSMIT_MODE						SIO4_USC_TMR
#define	TRANSMIT_SYNC						SIO4_USC_TSR
#define	USC_INTERRUPT_CONTROL				SIO4_USC_ICR

// USC Hardware Configuration Register
#define	HARDWARE_CONFIGURATION				SIO4_USC_HCR
#define	BRG0_ENABLE_MASK					SIO4_USC_HCR_BRG0E
#define	BRG0_ENABLE_SHIFT					0
#define	BRG0_MODE_MASK						SIO4_USC_HCR_BRG0S
#define	BRG0_MODE_SHIFT						1
#define	BRG1_ENABLE_MASK					SIO4_USC_HCR_BRG1E
#define	BRG1_ENABLE_SHIFT					4
#define	BRG1_MODE_MASK						SIO4_USC_HCR_BRG1S
#define	BRG1_MODE_SHIFT						5
#define	DPLL_DIVISOR_MASK					0x0C	// Accesses the high byte!
#define	DPLL_DIVISOR_SHIFT					2		// Accesses the high byte~
#define	DPLL_MODE_MASK						0x03	// Accesses the high byte!
#define	DPLL_MODE_SHIFT						0		// Accesses the high byte!

// CTS Cable Configuration
#define	SIO4_CTS_CABLE_CONFIG_INPUT			SIO4_CTS_CABLE_CONFIG_CTS_IN
#define	SIO4_CTS_CABLE_CONFIG_OUT_LOW		SIO4_CTS_CABLE_CONFIG_DRV_LOW
#define	SIO4_CTS_CABLE_CONFIG_OUT_HI		SIO4_CTS_CABLE_CONFIG_DRV_HI



typedef	signed char		SINT8;
typedef	signed short	SINT16;
typedef	signed long		SINT32;

// These are the error codes returned by the driver interface routines

typedef enum SIO4Status
{
	SIO4_NO_ERROR,				// Operation was successful
	SIO4_ALREADY_OPEN_ERROR,	// Device was already open
	SIO4_NOT_OPEN_ERROR,		// Device was not open
	SIO4_INV_PARAM_ERROR,		// Invalid parameter
	SIO4_READ_TIMEOUT,			// Timeout on Read
	SIO4_WRITE_TIMEOUT,			// Timeout on Write
	SIO4_NOT_IMPLEMENTED,		// ioctl() not implemented
	SIO4_RESOURCE_ERROR,		// Could not get a resource
	SIO4_DMA_FAILURE			// Set on DMA Failures
} SIO4_STATUS;

// These were used with the DMA IOCTL services.

typedef enum DMAChan
{
	DMA_CHAN_0,
	DMA_CHAN_1
} DMA_CHAN;

typedef enum ReadOrWrite
{
	DMA_WRITE,
	DMA_READ
} READ_OR_WRITE;

typedef struct SetupDMATransfer
{
	DMA_CHAN		eDMAChannel;
	UINT8			u8DemandModeEnable;
	READ_OR_WRITE	eReadWrite;
	UINT8*			pu8BufferAddr;
	UINT32			u32ByteCount;
} SETUP_DMA_TRANSFER;

typedef struct DMAControlBlock
{
	READ_OR_WRITE	eReadWrite;
	UINT32*			pu32BufferAddr;
	UINT32			u32ByteCount;
} DMA_CB;

typedef struct strDMAData
{
	SETUP_DMA_TRANSFER*	pstrDMATrans;
	DMA_CB*				pstrDMACb;
}DMA_DATA;

// structure for setting ISOCHRProtocol

typedef struct ISOCHRProt
{
	UINT8	u8TwoStopBits;
} ISO_CHR_PROTOCOL;



#endif
