// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/osc_unknown.c $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	osc_unknown_close
*
*	Purpose:
*
*		Perform cleanup after the channel is closed.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

void osc_unknown_close(dev_data_t* dev, int index)
{
	osc_fixed_close(dev, index);
}



/******************************************************************************
*
*	Function:	osc_unknown_info
*
*	Purpose:
*
*		Process an Oscillator Informatio request. We don't realy do anything
*		here as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_info(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_info(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_init
*
*	Purpose:
*
*		Process an Oscillator Initialization request. We don't realy do
*		anything here as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_init(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_init(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_measure
*
*	Purpose:
*
*		Process a Frquency Measurement request. We don't realy do anything here
*		as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_measure(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_measure(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_open
*
*	Purpose:
*
*		Perform any needed work as a device is being opened.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void osc_unknown_open(dev_data_t* dev, int index)
{
	osc_fixed_open(dev, index);
}



/******************************************************************************
*
*	Function:	osc_unknown_program
*
*	Purpose:
*
*		Process an Oscillator Programming request. We don't realy do anything
*		here as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_program(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_program(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_reference
*
*	Purpose:
*
*		Process a Reference Frquency request. We don't realy do anything here
*		as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		>= 0	Success.
*		< 0		Try another configuration option.
*
******************************************************************************/

int osc_unknown_reference(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_reference(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_reset
*
*	Purpose:
*
*		Process an Oscillator Reset request. We don't realy do anything here as
*		the oscillator frequency cannot be altered.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_reset(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret			= osc_fixed_reset(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



/******************************************************************************
*
*	Function:	osc_unknown_startup
*
*	Purpose:
*
*		Process an Oscillator Startup request. We don't realy do anything here
*		as we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void osc_unknown_startup(dev_data_t* dev)
{
	osc_fixed_startup(dev);
}



/******************************************************************************
*
*	Function:	osc_unknown_test
*
*	Purpose:
*
*		Process an Oscillator Test request. We don't realy do anything here as
*		we have no idea what support is present.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int osc_unknown_test(dev_data_t* dev, int index, sio4_osc_t* arg)
{
	int	ret;

	ret		= osc_fixed_test(dev, index, arg);
	arg->chip	= SIO4_OSC_CHIP_UNKNOWN;
	return(ret);
}



