// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/mp.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	mp_close
*
*	Purpose:
*
*		Perform cleanup after the channel is closed.
*
*	Arguments:
*
*		chan	The channel structure to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_close(chan_data_t* chan)
{
	dev_data_t*	dev	= chan->dev;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			mp_unknown_close(dev, chan->index);
			break;

		case SIO4_MP_CHIP_FIXED:

			mp_fixed_close(dev, chan->index);
			break;

		case SIO4_MP_CHIP_SP508:

			mp_sp508_close(dev, chan->index);
			break;
	}
}



/******************************************************************************
*
*	Function:	mp_config_ioctl
*
*	Purpose:
*
*		Implement the MP Config IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_config_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t*	parm	= arg;
	int			ret;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			ret	= mp_unknown_config(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_FIXED:

			ret	= mp_fixed_config(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_SP508:

			ret	= mp_sp508_config(dev, chan->index, parm);
			break;
	}

	parm->chip	= dev->cache.mp_chip;
	return(ret);
}



/******************************************************************************
*
*	Function:	mp_info_ioctl
*
*	Purpose:
*
*		Implement the MP Info IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_info_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t*	parm	= arg;
	int			ret;

	parm->prot_want	= SIO4_MP_PROT_READ;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			ret	= mp_unknown_config(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_FIXED:

			ret	= mp_fixed_config(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_SP508:

			ret	= mp_sp508_config(dev, chan->index, parm);
			break;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	mp_init_ioctl
*
*	Purpose:
*
*		Implement the MP Initialize IOCTL service. Initialize the given
*		channel's MP source.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_init_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t*	parm	= arg;
	int			ret;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			ret	= mp_unknown_init(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_FIXED:

			ret	= mp_fixed_init(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_SP508:

			ret	= mp_sp508_init(dev, chan->index, parm);
			break;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	mp_open
*
*	Purpose:
*
*		Perform setup for a channel being opened.
*
*	Arguments:
*
*		chan	The channel structure to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_open(chan_data_t* chan)
{
	dev_data_t*	dev	= chan->dev;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			mp_unknown_open(dev, chan->index);
			break;

		case SIO4_MP_CHIP_FIXED:

			mp_fixed_open(dev, chan->index);
			break;

		case SIO4_MP_CHIP_SP508:

			mp_sp508_open(dev, chan->index);
			break;
	}
}



/******************************************************************************
*
*	Function:	mp_reset_ioctl
*
*	Purpose:
*
*		Implement the MP Reset IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_reset_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t*	parm	= arg;
	int			ret;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			ret	= mp_unknown_reset(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_FIXED:

			ret	= mp_fixed_reset(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_SP508:

			ret	= mp_sp508_reset(dev, chan->index, parm);
			break;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	mp_startup
*
*	Purpose:
*
*		Perform a one-time initialization of the MP code.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_startup(dev_data_t* dev)
{
	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			mp_unknown_startup(dev);
			break;

		case SIO4_MP_CHIP_FIXED:

			mp_fixed_startup(dev);
			break;

		case SIO4_MP_CHIP_SP508:

			mp_sp508_startup(dev);
			break;
	}
}



/******************************************************************************
*
*	Function:	mp_test_ioctl
*
*	Purpose:
*
*		Implement the MP Test IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_test_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	sio4_mp_t*	parm	= arg;
	int			ret;

	switch (dev->cache.mp_chip)
	{
		default:
		case SIO4_MP_CHIP_UNKNOWN:

			ret	= mp_unknown_test(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_FIXED:

			ret	= mp_fixed_test(dev, chan->index, parm);
			break;

		case SIO4_MP_CHIP_SP508:

			ret	= mp_sp508_test(dev, chan->index, parm);
			break;
	}

	parm->chip	= dev->cache.mp_chip;
	return(ret);
}



