// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/fasync.c $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	gsc_fasync
*
*	Purpose:
*
*		Implement the drivers fasync() service.
*
*	Arguments:
*
*		inode	The device inode structure.
*
*		filp	The file access structure.
*
*		mode	The access mode desired.
*
*	Returned:
*
*		0		All is well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 gsc_fasync(int inode, struct file* filp, int mode)
{
	chan_data_t*	chan;
	s32				ret;

	ret	= dev_lock_filp(filp, &chan);

	if (ret == 0)
	{
		ret	= fasync_helper(inode, filp, mode, &chan->irq.fasync);
		os_sem_unlock(&chan->sem);
	}

	return(ret);
}



