// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/channel.c $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	channel_reset_ioctl
*
*	Purpose:
*
*		Implement the Channel Reset IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 channel_reset_ioctl(chan_data_t* chan, void* arg)
{
	dev_data_t*	dev		= chan->dev;
	s32			fw_type;
	sio4_mp_t	mp;
	sio4_osc_t	osc;
	u32			value;

	// Initialize the interrupts.
	value	= os_reg_mem_rx_u32(dev, dev->vaddr.gsc_icr_32);
	value	&= ~chan->cache.gsc_irq_mask;
	value	&= dev->cache.irq_mask;
	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_icr_32, value);

	if (dev->cache.reg_ielr)
	{
		os_reg_mem_mx_u32(	dev,
							chan->dev->vaddr.gsc_ielr_32,
							chan->cache.gsc_ielr_defalt,
							chan->cache.gsc_irq_mask);
	}

	if (dev->cache.reg_ihlr)
	{
		os_reg_mem_mx_u32(	dev,
							chan->dev->vaddr.gsc_ihlr_32,
							chan->cache.gsc_ihlr_defalt,
							chan->cache.gsc_irq_mask);
	}

	// Reset the FIFOs.
	os_reg_mem_tx_u32(dev, chan->vaddr.gsc_tar_32, 0x070007);
	os_reg_mem_tx_u32(dev, chan->vaddr.gsc_rar_32, 0x070007);
	SIO4ResetFifo(chan, (void*) TX_AND_RX_FIFO);

	// Initialize the Pin Source Register.
	os_reg_mem_tx_u32(dev, chan->vaddr.gsc_psrcr_32, 0);

	// Reset the programmable oscillator, if appropriate.

	if (chan->dev->cache.osc_per_chan)
		osc_reset_ioctl(chan, &osc);

	// Reset the programmable transceivers.
	mp_reset_ioctl(chan, &mp);

	fw_type_config_get(chan, &fw_type);

	if (fw_type == SIO4_FW_TYPE_CONFIG_Z16C30)
		usc_reset_ioctl(chan, NULL);

	// Reset the FIFOs.
	value	= SIO4_GSC_CSR_TFR | SIO4_GSC_CSR_RFR;
	os_reg_mem_tx_u32(dev, chan->vaddr.gsc_csr_32, value);
	os_time_us_delay(10000);	// worst case for older devices

	// Disable the cable clock signals.
	os_reg_mem_mx_u32(	dev,
						chan->dev->vaddr.gsc_ccr_32,
						0,
						chan->cache.gsc_ccr_mask);

	// Initialize the Sync Detect byte.
	os_reg_mem_tx_u32(dev, chan->vaddr.gsc_sbr_32, 0);
	return(0);
}


